package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


/**
 * <i>“Contains properties used to assign an iOS Store mobile app to a group.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "vpnConfigurationId", 
    "uninstallOnDeviceRemoval"})
@JsonInclude(Include.NON_NULL)
public class IosStoreAppAssignmentSettings extends MobileAppAssignmentSettings implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("vpnConfigurationId")
    protected String vpnConfigurationId;

    @JsonProperty("uninstallOnDeviceRemoval")
    protected Boolean uninstallOnDeviceRemoval;

    protected IosStoreAppAssignmentSettings() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.iosStoreAppAssignmentSettings";
    }

    /**
     * <i>“The VPN Configuration Id to apply for this app.”</i>
     * 
     * @return property vpnConfigurationId
     */
    @Property(name="vpnConfigurationId")
    @JsonIgnore
    public Optional<String> getVpnConfigurationId() {
        return Optional.ofNullable(vpnConfigurationId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * vpnConfigurationId} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The VPN Configuration Id to apply for this app.”</i>
     * 
     * @param vpnConfigurationId
     *            new value of {@code vpnConfigurationId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code vpnConfigurationId} field changed
     */
    public IosStoreAppAssignmentSettings withVpnConfigurationId(String vpnConfigurationId) {
        IosStoreAppAssignmentSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosStoreAppAssignmentSettings");
        _x.vpnConfigurationId = vpnConfigurationId;
        return _x;
    }

    /**
     * <i>“Whether or not to uninstall the app when device is removed from Intune.”</i>
     * 
     * @return property uninstallOnDeviceRemoval
     */
    @Property(name="uninstallOnDeviceRemoval")
    @JsonIgnore
    public Optional<Boolean> getUninstallOnDeviceRemoval() {
        return Optional.ofNullable(uninstallOnDeviceRemoval);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * uninstallOnDeviceRemoval} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Whether or not to uninstall the app when device is removed from Intune.”</i>
     * 
     * @param uninstallOnDeviceRemoval
     *            new value of {@code uninstallOnDeviceRemoval} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code uninstallOnDeviceRemoval} field changed
     */
    public IosStoreAppAssignmentSettings withUninstallOnDeviceRemoval(Boolean uninstallOnDeviceRemoval) {
        IosStoreAppAssignmentSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosStoreAppAssignmentSettings");
        _x.uninstallOnDeviceRemoval = uninstallOnDeviceRemoval;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderIosStoreAppAssignmentSettings() {
        return new Builder();
    }

    public static final class Builder {
        private String vpnConfigurationId;
        private Boolean uninstallOnDeviceRemoval;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The VPN Configuration Id to apply for this app.”</i>
         * 
         * @param vpnConfigurationId
         *            value of {@code vpnConfigurationId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder vpnConfigurationId(String vpnConfigurationId) {
            this.vpnConfigurationId = vpnConfigurationId;
            this.changedFields = changedFields.add("vpnConfigurationId");
            return this;
        }

        /**
         * <i>“Whether or not to uninstall the app when device is removed from Intune.”</i>
         * 
         * @param uninstallOnDeviceRemoval
         *            value of {@code uninstallOnDeviceRemoval} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder uninstallOnDeviceRemoval(Boolean uninstallOnDeviceRemoval) {
            this.uninstallOnDeviceRemoval = uninstallOnDeviceRemoval;
            this.changedFields = changedFields.add("uninstallOnDeviceRemoval");
            return this;
        }

        public IosStoreAppAssignmentSettings build() {
            IosStoreAppAssignmentSettings _x = new IosStoreAppAssignmentSettings();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.iosStoreAppAssignmentSettings";
            _x.vpnConfigurationId = vpnConfigurationId;
            _x.uninstallOnDeviceRemoval = uninstallOnDeviceRemoval;
            return _x;
        }
    }

    private IosStoreAppAssignmentSettings _copy() {
        IosStoreAppAssignmentSettings _x = new IosStoreAppAssignmentSettings();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.vpnConfigurationId = vpnConfigurationId;
        _x.uninstallOnDeviceRemoval = uninstallOnDeviceRemoval;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("IosStoreAppAssignmentSettings[");
        b.append("vpnConfigurationId=");
        b.append(this.vpnConfigurationId);
        b.append(", ");
        b.append("uninstallOnDeviceRemoval=");
        b.append(this.uninstallOnDeviceRemoval);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
