package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <i>“Network Usage Rules allow enterprises to specify how managed apps use networks,
 * such as cellular data networks.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "managedApps", 
    "cellularDataBlockWhenRoaming", 
    "cellularDataBlocked"})
@JsonInclude(Include.NON_NULL)
public class IosNetworkUsageRule implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("managedApps")
    protected List<AppListItem> managedApps;

    @JsonProperty("managedApps@nextLink")
    protected String managedAppsNextLink;

    @JsonProperty("cellularDataBlockWhenRoaming")
    protected Boolean cellularDataBlockWhenRoaming;

    @JsonProperty("cellularDataBlocked")
    protected Boolean cellularDataBlocked;

    protected IosNetworkUsageRule() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.iosNetworkUsageRule";
    }

    /**
     * <i>“Information about the managed apps that this rule is going to apply to. This
     * collection can contain a maximum of 500 elements.”</i>
     * 
     * @return property managedApps
     */
    @Property(name="managedApps")
    @JsonIgnore
    public CollectionPage<AppListItem> getManagedApps() {
        return new CollectionPage<AppListItem>(contextPath, AppListItem.class, managedApps, Optional.ofNullable(managedAppsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Information about the managed apps that this rule is going to apply to. This
     * collection can contain a maximum of 500 elements.”</i>
     * 
     * @return property managedApps
     */
    @Property(name="managedApps")
    @JsonIgnore
    public CollectionPage<AppListItem> getManagedApps(HttpRequestOptions options) {
        return new CollectionPage<AppListItem>(contextPath, AppListItem.class, managedApps, Optional.ofNullable(managedAppsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“If set to true, corresponding managed apps will not be allowed to use cellular
     * data when roaming.”</i>
     * 
     * @return property cellularDataBlockWhenRoaming
     */
    @Property(name="cellularDataBlockWhenRoaming")
    @JsonIgnore
    public Optional<Boolean> getCellularDataBlockWhenRoaming() {
        return Optional.ofNullable(cellularDataBlockWhenRoaming);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * cellularDataBlockWhenRoaming} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“If set to true, corresponding managed apps will not be allowed to use cellular
     * data when roaming.”</i>
     * 
     * @param cellularDataBlockWhenRoaming
     *            new value of {@code cellularDataBlockWhenRoaming} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code cellularDataBlockWhenRoaming} field changed
     */
    public IosNetworkUsageRule withCellularDataBlockWhenRoaming(Boolean cellularDataBlockWhenRoaming) {
        IosNetworkUsageRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosNetworkUsageRule");
        _x.cellularDataBlockWhenRoaming = cellularDataBlockWhenRoaming;
        return _x;
    }

    /**
     * <i>“If set to true, corresponding managed apps will not be allowed to use cellular
     * data at any time.”</i>
     * 
     * @return property cellularDataBlocked
     */
    @Property(name="cellularDataBlocked")
    @JsonIgnore
    public Optional<Boolean> getCellularDataBlocked() {
        return Optional.ofNullable(cellularDataBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * cellularDataBlocked} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“If set to true, corresponding managed apps will not be allowed to use cellular
     * data at any time.”</i>
     * 
     * @param cellularDataBlocked
     *            new value of {@code cellularDataBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code cellularDataBlocked} field changed
     */
    public IosNetworkUsageRule withCellularDataBlocked(Boolean cellularDataBlocked) {
        IosNetworkUsageRule _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosNetworkUsageRule");
        _x.cellularDataBlocked = cellularDataBlocked;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<AppListItem> managedApps;
        private String managedAppsNextLink;
        private Boolean cellularDataBlockWhenRoaming;
        private Boolean cellularDataBlocked;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Information about the managed apps that this rule is going to apply to. This
         * collection can contain a maximum of 500 elements.”</i>
         * 
         * @param managedApps
         *            value of {@code managedApps} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder managedApps(List<AppListItem> managedApps) {
            this.managedApps = managedApps;
            this.changedFields = changedFields.add("managedApps");
            return this;
        }

        /**
         * <i>“Information about the managed apps that this rule is going to apply to. This
         * collection can contain a maximum of 500 elements.”</i>
         * 
         * @param managedApps
         *            value of {@code managedApps} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder managedApps(AppListItem... managedApps) {
            return managedApps(Arrays.asList(managedApps));
        }

        /**
         * <i>“Information about the managed apps that this rule is going to apply to. This
         * collection can contain a maximum of 500 elements.”</i>
         * 
         * @param managedAppsNextLink
         *            value of {@code managedApps@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder managedAppsNextLink(String managedAppsNextLink) {
            this.managedAppsNextLink = managedAppsNextLink;
            this.changedFields = changedFields.add("managedApps");
            return this;
        }

        /**
         * <i>“If set to true, corresponding managed apps will not be allowed to use cellular
         * data when roaming.”</i>
         * 
         * @param cellularDataBlockWhenRoaming
         *            value of {@code cellularDataBlockWhenRoaming} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder cellularDataBlockWhenRoaming(Boolean cellularDataBlockWhenRoaming) {
            this.cellularDataBlockWhenRoaming = cellularDataBlockWhenRoaming;
            this.changedFields = changedFields.add("cellularDataBlockWhenRoaming");
            return this;
        }

        /**
         * <i>“If set to true, corresponding managed apps will not be allowed to use cellular
         * data at any time.”</i>
         * 
         * @param cellularDataBlocked
         *            value of {@code cellularDataBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder cellularDataBlocked(Boolean cellularDataBlocked) {
            this.cellularDataBlocked = cellularDataBlocked;
            this.changedFields = changedFields.add("cellularDataBlocked");
            return this;
        }

        public IosNetworkUsageRule build() {
            IosNetworkUsageRule _x = new IosNetworkUsageRule();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.iosNetworkUsageRule";
            _x.managedApps = managedApps;
            _x.managedAppsNextLink = managedAppsNextLink;
            _x.cellularDataBlockWhenRoaming = cellularDataBlockWhenRoaming;
            _x.cellularDataBlocked = cellularDataBlocked;
            return _x;
        }
    }

    private IosNetworkUsageRule _copy() {
        IosNetworkUsageRule _x = new IosNetworkUsageRule();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.managedApps = managedApps;
        _x.cellularDataBlockWhenRoaming = cellularDataBlockWhenRoaming;
        _x.cellularDataBlocked = cellularDataBlocked;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("IosNetworkUsageRule[");
        b.append("managedApps=");
        b.append(this.managedApps);
        b.append(", ");
        b.append("cellularDataBlockWhenRoaming=");
        b.append(this.cellularDataBlockWhenRoaming);
        b.append(", ");
        b.append("cellularDataBlocked=");
        b.append(this.cellularDataBlocked);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
