package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <i>“A folder containing apps on the Home Screen”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "apps"})
@JsonInclude(Include.NON_NULL)
public class IosHomeScreenFolderPage implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("apps")
    protected List<IosHomeScreenApp> apps;

    @JsonProperty("apps@nextLink")
    protected String appsNextLink;

    protected IosHomeScreenFolderPage() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.iosHomeScreenFolderPage";
    }

    /**
     * <i>“Name of the folder page”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Name of the folder page”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public IosHomeScreenFolderPage withDisplayName(String displayName) {
        IosHomeScreenFolderPage _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosHomeScreenFolderPage");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“A list of apps to appear on a page within a folder. This collection can contain
     * a maximum of 500 elements.”</i>
     * 
     * @return property apps
     */
    @Property(name="apps")
    @JsonIgnore
    public CollectionPage<IosHomeScreenApp> getApps() {
        return new CollectionPage<IosHomeScreenApp>(contextPath, IosHomeScreenApp.class, apps, Optional.ofNullable(appsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“A list of apps to appear on a page within a folder. This collection can contain
     * a maximum of 500 elements.”</i>
     * 
     * @return property apps
     */
    @Property(name="apps")
    @JsonIgnore
    public CollectionPage<IosHomeScreenApp> getApps(HttpRequestOptions options) {
        return new CollectionPage<IosHomeScreenApp>(contextPath, IosHomeScreenApp.class, apps, Optional.ofNullable(appsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String displayName;
        private List<IosHomeScreenApp> apps;
        private String appsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Name of the folder page”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“A list of apps to appear on a page within a folder. This collection can contain
         * a maximum of 500 elements.”</i>
         * 
         * @param apps
         *            value of {@code apps} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder apps(List<IosHomeScreenApp> apps) {
            this.apps = apps;
            this.changedFields = changedFields.add("apps");
            return this;
        }

        /**
         * <i>“A list of apps to appear on a page within a folder. This collection can contain
         * a maximum of 500 elements.”</i>
         * 
         * @param apps
         *            value of {@code apps} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder apps(IosHomeScreenApp... apps) {
            return apps(Arrays.asList(apps));
        }

        /**
         * <i>“A list of apps to appear on a page within a folder. This collection can contain
         * a maximum of 500 elements.”</i>
         * 
         * @param appsNextLink
         *            value of {@code apps@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appsNextLink(String appsNextLink) {
            this.appsNextLink = appsNextLink;
            this.changedFields = changedFields.add("apps");
            return this;
        }

        public IosHomeScreenFolderPage build() {
            IosHomeScreenFolderPage _x = new IosHomeScreenFolderPage();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.iosHomeScreenFolderPage";
            _x.displayName = displayName;
            _x.apps = apps;
            _x.appsNextLink = appsNextLink;
            return _x;
        }
    }

    private IosHomeScreenFolderPage _copy() {
        IosHomeScreenFolderPage _x = new IosHomeScreenFolderPage();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.displayName = displayName;
        _x.apps = apps;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("IosHomeScreenFolderPage[");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("apps=");
        b.append(this.apps);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
