package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


/**
 * <i>“Represents an icon for an app on the Home Screen”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "bundleID"})
@JsonInclude(Include.NON_NULL)
public class IosHomeScreenApp extends IosHomeScreenItem implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("bundleID")
    protected String bundleID;

    protected IosHomeScreenApp() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.iosHomeScreenApp";
    }

    /**
     * <i>“BundleID of app”</i>
     * 
     * @return property bundleID
     */
    @Property(name="bundleID")
    @JsonIgnore
    public Optional<String> getBundleID() {
        return Optional.ofNullable(bundleID);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code bundleID} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“BundleID of app”</i>
     * 
     * @param bundleID
     *            new value of {@code bundleID} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code bundleID} field changed
     */
    public IosHomeScreenApp withBundleID(String bundleID) {
        IosHomeScreenApp _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iosHomeScreenApp");
        _x.bundleID = bundleID;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderIosHomeScreenApp() {
        return new Builder();
    }

    public static final class Builder {
        private String displayName;
        private String bundleID;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“BundleID of app”</i>
         * 
         * @param bundleID
         *            value of {@code bundleID} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder bundleID(String bundleID) {
            this.bundleID = bundleID;
            this.changedFields = changedFields.add("bundleID");
            return this;
        }

        public IosHomeScreenApp build() {
            IosHomeScreenApp _x = new IosHomeScreenApp();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.iosHomeScreenApp";
            _x.displayName = displayName;
            _x.bundleID = bundleID;
            return _x;
        }
    }

    private IosHomeScreenApp _copy() {
        IosHomeScreenApp _x = new IosHomeScreenApp();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.displayName = displayName;
        _x.bundleID = bundleID;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("IosHomeScreenApp[");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("bundleID=");
        b.append(this.bundleID);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
