package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "ccRecipients", 
    "messageLanguage", 
    "customizedMessageBody"})
@JsonInclude(Include.NON_NULL)
public class InvitedUserMessageInfo implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("ccRecipients")
    protected List<Recipient> ccRecipients;

    @JsonProperty("ccRecipients@nextLink")
    protected String ccRecipientsNextLink;

    @JsonProperty("messageLanguage")
    protected String messageLanguage;

    @JsonProperty("customizedMessageBody")
    protected String customizedMessageBody;

    protected InvitedUserMessageInfo() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.invitedUserMessageInfo";
    }

    @Property(name="ccRecipients")
    @JsonIgnore
    public CollectionPage<Recipient> getCcRecipients() {
        return new CollectionPage<Recipient>(contextPath, Recipient.class, ccRecipients, Optional.ofNullable(ccRecipientsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="ccRecipients")
    @JsonIgnore
    public CollectionPage<Recipient> getCcRecipients(HttpRequestOptions options) {
        return new CollectionPage<Recipient>(contextPath, Recipient.class, ccRecipients, Optional.ofNullable(ccRecipientsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="messageLanguage")
    @JsonIgnore
    public Optional<String> getMessageLanguage() {
        return Optional.ofNullable(messageLanguage);
    }

    public InvitedUserMessageInfo withMessageLanguage(String messageLanguage) {
        InvitedUserMessageInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.invitedUserMessageInfo");
        _x.messageLanguage = messageLanguage;
        return _x;
    }

    @Property(name="customizedMessageBody")
    @JsonIgnore
    public Optional<String> getCustomizedMessageBody() {
        return Optional.ofNullable(customizedMessageBody);
    }

    public InvitedUserMessageInfo withCustomizedMessageBody(String customizedMessageBody) {
        InvitedUserMessageInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.invitedUserMessageInfo");
        _x.customizedMessageBody = customizedMessageBody;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<Recipient> ccRecipients;
        private String ccRecipientsNextLink;
        private String messageLanguage;
        private String customizedMessageBody;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder ccRecipients(List<Recipient> ccRecipients) {
            this.ccRecipients = ccRecipients;
            this.changedFields = changedFields.add("ccRecipients");
            return this;
        }

        public Builder ccRecipients(Recipient... ccRecipients) {
            return ccRecipients(Arrays.asList(ccRecipients));
        }

        public Builder ccRecipientsNextLink(String ccRecipientsNextLink) {
            this.ccRecipientsNextLink = ccRecipientsNextLink;
            this.changedFields = changedFields.add("ccRecipients");
            return this;
        }

        public Builder messageLanguage(String messageLanguage) {
            this.messageLanguage = messageLanguage;
            this.changedFields = changedFields.add("messageLanguage");
            return this;
        }

        public Builder customizedMessageBody(String customizedMessageBody) {
            this.customizedMessageBody = customizedMessageBody;
            this.changedFields = changedFields.add("customizedMessageBody");
            return this;
        }

        public InvitedUserMessageInfo build() {
            InvitedUserMessageInfo _x = new InvitedUserMessageInfo();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.invitedUserMessageInfo";
            _x.ccRecipients = ccRecipients;
            _x.ccRecipientsNextLink = ccRecipientsNextLink;
            _x.messageLanguage = messageLanguage;
            _x.customizedMessageBody = customizedMessageBody;
            return _x;
        }
    }

    private InvitedUserMessageInfo _copy() {
        InvitedUserMessageInfo _x = new InvitedUserMessageInfo();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.ccRecipients = ccRecipients;
        _x.messageLanguage = messageLanguage;
        _x.customizedMessageBody = customizedMessageBody;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("InvitedUserMessageInfo[");
        b.append("ccRecipients=");
        b.append(this.ccRecipients);
        b.append(", ");
        b.append("messageLanguage=");
        b.append(this.messageLanguage);
        b.append(", ");
        b.append("customizedMessageBody=");
        b.append(this.customizedMessageBody);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
