package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.EndpointType;

@JsonPropertyOrder({
    "@odata.type", 
    "identity", 
    "endpointType", 
    "replacesCallId"})
@JsonInclude(Include.NON_NULL)
public class InvitationParticipantInfo implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("identity")
    protected IdentitySet identity;

    @JsonProperty("endpointType")
    protected EndpointType endpointType;

    @JsonProperty("replacesCallId")
    protected String replacesCallId;

    protected InvitationParticipantInfo() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.invitationParticipantInfo";
    }

    @Property(name="identity")
    @JsonIgnore
    public Optional<IdentitySet> getIdentity() {
        return Optional.ofNullable(identity);
    }

    public InvitationParticipantInfo withIdentity(IdentitySet identity) {
        InvitationParticipantInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.invitationParticipantInfo");
        _x.identity = identity;
        return _x;
    }

    @Property(name="endpointType")
    @JsonIgnore
    public Optional<EndpointType> getEndpointType() {
        return Optional.ofNullable(endpointType);
    }

    public InvitationParticipantInfo withEndpointType(EndpointType endpointType) {
        InvitationParticipantInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.invitationParticipantInfo");
        _x.endpointType = endpointType;
        return _x;
    }

    @Property(name="replacesCallId")
    @JsonIgnore
    public Optional<String> getReplacesCallId() {
        return Optional.ofNullable(replacesCallId);
    }

    public InvitationParticipantInfo withReplacesCallId(String replacesCallId) {
        InvitationParticipantInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.invitationParticipantInfo");
        _x.replacesCallId = replacesCallId;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private IdentitySet identity;
        private EndpointType endpointType;
        private String replacesCallId;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder identity(IdentitySet identity) {
            this.identity = identity;
            this.changedFields = changedFields.add("identity");
            return this;
        }

        public Builder endpointType(EndpointType endpointType) {
            this.endpointType = endpointType;
            this.changedFields = changedFields.add("endpointType");
            return this;
        }

        public Builder replacesCallId(String replacesCallId) {
            this.replacesCallId = replacesCallId;
            this.changedFields = changedFields.add("replacesCallId");
            return this;
        }

        public InvitationParticipantInfo build() {
            InvitationParticipantInfo _x = new InvitationParticipantInfo();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.invitationParticipantInfo";
            _x.identity = identity;
            _x.endpointType = endpointType;
            _x.replacesCallId = replacesCallId;
            return _x;
        }
    }

    private InvitationParticipantInfo _copy() {
        InvitationParticipantInfo _x = new InvitationParticipantInfo();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.identity = identity;
        _x.endpointType = endpointType;
        _x.replacesCallId = replacesCallId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("InvitationParticipantInfo[");
        b.append("identity=");
        b.append(this.identity);
        b.append(", ");
        b.append("endpointType=");
        b.append(this.endpointType);
        b.append(", ");
        b.append("replacesCallId=");
        b.append(this.replacesCallId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
