package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.EnrollmentAvailabilityOptions;
import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <i>“intuneBrand contains data which is used in customizing the appearance of the
 * Company Portal applications as well as the end user web portal.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "themeColor", 
    "showLogo", 
    "lightBackgroundLogo", 
    "darkBackgroundLogo", 
    "showNameNextToLogo", 
    "landingPageCustomizedImage", 
    "showDisplayNameNextToLogo", 
    "roleScopeTagIds", 
    "contactITName", 
    "contactITPhoneNumber", 
    "contactITEmailAddress", 
    "contactITNotes", 
    "onlineSupportSiteUrl", 
    "onlineSupportSiteName", 
    "privacyUrl", 
    "customPrivacyMessage", 
    "isRemoveDeviceDisabled", 
    "isFactoryResetDisabled", 
    "companyPortalBlockedActions", 
    "showAzureADEnterpriseApps", 
    "showOfficeWebApps", 
    "sendDeviceOwnershipChangePushNotification", 
    "enrollmentAvailability"})
@JsonInclude(Include.NON_NULL)
public class IntuneBrand implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("themeColor")
    protected RgbColor themeColor;

    @JsonProperty("showLogo")
    protected Boolean showLogo;

    @JsonProperty("lightBackgroundLogo")
    protected MimeContent lightBackgroundLogo;

    @JsonProperty("darkBackgroundLogo")
    protected MimeContent darkBackgroundLogo;

    @JsonProperty("showNameNextToLogo")
    protected Boolean showNameNextToLogo;

    @JsonProperty("landingPageCustomizedImage")
    protected MimeContent landingPageCustomizedImage;

    @JsonProperty("showDisplayNameNextToLogo")
    protected Boolean showDisplayNameNextToLogo;

    @JsonProperty("roleScopeTagIds")
    protected List<String> roleScopeTagIds;

    @JsonProperty("roleScopeTagIds@nextLink")
    protected String roleScopeTagIdsNextLink;

    @JsonProperty("contactITName")
    protected String contactITName;

    @JsonProperty("contactITPhoneNumber")
    protected String contactITPhoneNumber;

    @JsonProperty("contactITEmailAddress")
    protected String contactITEmailAddress;

    @JsonProperty("contactITNotes")
    protected String contactITNotes;

    @JsonProperty("onlineSupportSiteUrl")
    protected String onlineSupportSiteUrl;

    @JsonProperty("onlineSupportSiteName")
    protected String onlineSupportSiteName;

    @JsonProperty("privacyUrl")
    protected String privacyUrl;

    @JsonProperty("customPrivacyMessage")
    protected String customPrivacyMessage;

    @JsonProperty("isRemoveDeviceDisabled")
    protected Boolean isRemoveDeviceDisabled;

    @JsonProperty("isFactoryResetDisabled")
    protected Boolean isFactoryResetDisabled;

    @JsonProperty("companyPortalBlockedActions")
    protected List<CompanyPortalBlockedAction> companyPortalBlockedActions;

    @JsonProperty("companyPortalBlockedActions@nextLink")
    protected String companyPortalBlockedActionsNextLink;

    @JsonProperty("showAzureADEnterpriseApps")
    protected Boolean showAzureADEnterpriseApps;

    @JsonProperty("showOfficeWebApps")
    protected Boolean showOfficeWebApps;

    @JsonProperty("sendDeviceOwnershipChangePushNotification")
    protected Boolean sendDeviceOwnershipChangePushNotification;

    @JsonProperty("enrollmentAvailability")
    protected EnrollmentAvailabilityOptions enrollmentAvailability;

    protected IntuneBrand() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.intuneBrand";
    }

    /**
     * <i>“Company/organization name that is displayed to end users.”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Company/organization name that is displayed to end users.”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public IntuneBrand withDisplayName(String displayName) {
        IntuneBrand _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.intuneBrand");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“Primary theme color used in the Company Portal applications and web portal.”</i>
     * 
     * @return property themeColor
     */
    @Property(name="themeColor")
    @JsonIgnore
    public Optional<RgbColor> getThemeColor() {
        return Optional.ofNullable(themeColor);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code themeColor} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Primary theme color used in the Company Portal applications and web portal.”</i>
     * 
     * @param themeColor
     *            new value of {@code themeColor} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code themeColor} field changed
     */
    public IntuneBrand withThemeColor(RgbColor themeColor) {
        IntuneBrand _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.intuneBrand");
        _x.themeColor = themeColor;
        return _x;
    }

    /**
     * <i>“Boolean that represents whether the administrator-supplied logo images are shown
     * or not shown.”</i>
     * 
     * @return property showLogo
     */
    @Property(name="showLogo")
    @JsonIgnore
    public Optional<Boolean> getShowLogo() {
        return Optional.ofNullable(showLogo);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code showLogo} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Boolean that represents whether the administrator-supplied logo images are shown
     * or not shown.”</i>
     * 
     * @param showLogo
     *            new value of {@code showLogo} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code showLogo} field changed
     */
    public IntuneBrand withShowLogo(Boolean showLogo) {
        IntuneBrand _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.intuneBrand");
        _x.showLogo = showLogo;
        return _x;
    }

    /**
     * <i>“Logo image displayed in Company Portal apps which have a light background behind
     * the logo.”</i>
     * 
     * @return property lightBackgroundLogo
     */
    @Property(name="lightBackgroundLogo")
    @JsonIgnore
    public Optional<MimeContent> getLightBackgroundLogo() {
        return Optional.ofNullable(lightBackgroundLogo);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lightBackgroundLogo} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Logo image displayed in Company Portal apps which have a light background behind
     * the logo.”</i>
     * 
     * @param lightBackgroundLogo
     *            new value of {@code lightBackgroundLogo} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lightBackgroundLogo} field changed
     */
    public IntuneBrand withLightBackgroundLogo(MimeContent lightBackgroundLogo) {
        IntuneBrand _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.intuneBrand");
        _x.lightBackgroundLogo = lightBackgroundLogo;
        return _x;
    }

    /**
     * <i>“Logo image displayed in Company Portal apps which have a dark background behind
     * the logo.”</i>
     * 
     * @return property darkBackgroundLogo
     */
    @Property(name="darkBackgroundLogo")
    @JsonIgnore
    public Optional<MimeContent> getDarkBackgroundLogo() {
        return Optional.ofNullable(darkBackgroundLogo);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * darkBackgroundLogo} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Logo image displayed in Company Portal apps which have a dark background behind
     * the logo.”</i>
     * 
     * @param darkBackgroundLogo
     *            new value of {@code darkBackgroundLogo} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code darkBackgroundLogo} field changed
     */
    public IntuneBrand withDarkBackgroundLogo(MimeContent darkBackgroundLogo) {
        IntuneBrand _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.intuneBrand");
        _x.darkBackgroundLogo = darkBackgroundLogo;
        return _x;
    }

    /**
     * <i>“Boolean that represents whether the administrator-supplied display name will be
     * shown next to the logo image.”</i>
     * 
     * @return property showNameNextToLogo
     */
    @Property(name="showNameNextToLogo")
    @JsonIgnore
    public Optional<Boolean> getShowNameNextToLogo() {
        return Optional.ofNullable(showNameNextToLogo);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * showNameNextToLogo} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Boolean that represents whether the administrator-supplied display name will be
     * shown next to the logo image.”</i>
     * 
     * @param showNameNextToLogo
     *            new value of {@code showNameNextToLogo} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code showNameNextToLogo} field changed
     */
    public IntuneBrand withShowNameNextToLogo(Boolean showNameNextToLogo) {
        IntuneBrand _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.intuneBrand");
        _x.showNameNextToLogo = showNameNextToLogo;
        return _x;
    }

    /**
     * <i>“Customized image displayed in Company Portal app landing page”</i>
     * 
     * @return property landingPageCustomizedImage
     */
    @Property(name="landingPageCustomizedImage")
    @JsonIgnore
    public Optional<MimeContent> getLandingPageCustomizedImage() {
        return Optional.ofNullable(landingPageCustomizedImage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * landingPageCustomizedImage} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Customized image displayed in Company Portal app landing page”</i>
     * 
     * @param landingPageCustomizedImage
     *            new value of {@code landingPageCustomizedImage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code landingPageCustomizedImage} field changed
     */
    public IntuneBrand withLandingPageCustomizedImage(MimeContent landingPageCustomizedImage) {
        IntuneBrand _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.intuneBrand");
        _x.landingPageCustomizedImage = landingPageCustomizedImage;
        return _x;
    }

    /**
     * <i>“Boolean that represents whether the administrator-supplied display name will be
     * shown next to the logo image.”</i>
     * 
     * @return property showDisplayNameNextToLogo
     */
    @Property(name="showDisplayNameNextToLogo")
    @JsonIgnore
    public Optional<Boolean> getShowDisplayNameNextToLogo() {
        return Optional.ofNullable(showDisplayNameNextToLogo);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * showDisplayNameNextToLogo} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Boolean that represents whether the administrator-supplied display name will be
     * shown next to the logo image.”</i>
     * 
     * @param showDisplayNameNextToLogo
     *            new value of {@code showDisplayNameNextToLogo} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code showDisplayNameNextToLogo} field changed
     */
    public IntuneBrand withShowDisplayNameNextToLogo(Boolean showDisplayNameNextToLogo) {
        IntuneBrand _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.intuneBrand");
        _x.showDisplayNameNextToLogo = showDisplayNameNextToLogo;
        return _x;
    }

    /**
     * <i>“List of scope tags assigned to the default branding profile”</i>
     * 
     * @return property roleScopeTagIds
     */
    @Property(name="roleScopeTagIds")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTagIds() {
        return new CollectionPage<String>(contextPath, String.class, roleScopeTagIds, Optional.ofNullable(roleScopeTagIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“List of scope tags assigned to the default branding profile”</i>
     * 
     * @return property roleScopeTagIds
     */
    @Property(name="roleScopeTagIds")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTagIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, roleScopeTagIds, Optional.ofNullable(roleScopeTagIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Name of the person/organization responsible for IT support.”</i>
     * 
     * @return property contactITName
     */
    @Property(name="contactITName")
    @JsonIgnore
    public Optional<String> getContactITName() {
        return Optional.ofNullable(contactITName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code contactITName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Name of the person/organization responsible for IT support.”</i>
     * 
     * @param contactITName
     *            new value of {@code contactITName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code contactITName} field changed
     */
    public IntuneBrand withContactITName(String contactITName) {
        IntuneBrand _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.intuneBrand");
        _x.contactITName = contactITName;
        return _x;
    }

    /**
     * <i>“Phone number of the person/organization responsible for IT support.”</i>
     * 
     * @return property contactITPhoneNumber
     */
    @Property(name="contactITPhoneNumber")
    @JsonIgnore
    public Optional<String> getContactITPhoneNumber() {
        return Optional.ofNullable(contactITPhoneNumber);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * contactITPhoneNumber} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Phone number of the person/organization responsible for IT support.”</i>
     * 
     * @param contactITPhoneNumber
     *            new value of {@code contactITPhoneNumber} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code contactITPhoneNumber} field changed
     */
    public IntuneBrand withContactITPhoneNumber(String contactITPhoneNumber) {
        IntuneBrand _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.intuneBrand");
        _x.contactITPhoneNumber = contactITPhoneNumber;
        return _x;
    }

    /**
     * <i>“Email address of the person/organization responsible for IT support.”</i>
     * 
     * @return property contactITEmailAddress
     */
    @Property(name="contactITEmailAddress")
    @JsonIgnore
    public Optional<String> getContactITEmailAddress() {
        return Optional.ofNullable(contactITEmailAddress);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * contactITEmailAddress} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Email address of the person/organization responsible for IT support.”</i>
     * 
     * @param contactITEmailAddress
     *            new value of {@code contactITEmailAddress} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code contactITEmailAddress} field changed
     */
    public IntuneBrand withContactITEmailAddress(String contactITEmailAddress) {
        IntuneBrand _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.intuneBrand");
        _x.contactITEmailAddress = contactITEmailAddress;
        return _x;
    }

    /**
     * <i>“Text comments regarding the person/organization responsible for IT support.”</i>
     * 
     * @return property contactITNotes
     */
    @Property(name="contactITNotes")
    @JsonIgnore
    public Optional<String> getContactITNotes() {
        return Optional.ofNullable(contactITNotes);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code contactITNotes}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Text comments regarding the person/organization responsible for IT support.”</i>
     * 
     * @param contactITNotes
     *            new value of {@code contactITNotes} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code contactITNotes} field changed
     */
    public IntuneBrand withContactITNotes(String contactITNotes) {
        IntuneBrand _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.intuneBrand");
        _x.contactITNotes = contactITNotes;
        return _x;
    }

    /**
     * <i>“URL to the company/organization’s IT helpdesk site.”</i>
     * 
     * @return property onlineSupportSiteUrl
     */
    @Property(name="onlineSupportSiteUrl")
    @JsonIgnore
    public Optional<String> getOnlineSupportSiteUrl() {
        return Optional.ofNullable(onlineSupportSiteUrl);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * onlineSupportSiteUrl} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“URL to the company/organization’s IT helpdesk site.”</i>
     * 
     * @param onlineSupportSiteUrl
     *            new value of {@code onlineSupportSiteUrl} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code onlineSupportSiteUrl} field changed
     */
    public IntuneBrand withOnlineSupportSiteUrl(String onlineSupportSiteUrl) {
        IntuneBrand _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.intuneBrand");
        _x.onlineSupportSiteUrl = onlineSupportSiteUrl;
        return _x;
    }

    /**
     * <i>“Display name of the company/organization’s IT helpdesk site.”</i>
     * 
     * @return property onlineSupportSiteName
     */
    @Property(name="onlineSupportSiteName")
    @JsonIgnore
    public Optional<String> getOnlineSupportSiteName() {
        return Optional.ofNullable(onlineSupportSiteName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * onlineSupportSiteName} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Display name of the company/organization’s IT helpdesk site.”</i>
     * 
     * @param onlineSupportSiteName
     *            new value of {@code onlineSupportSiteName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code onlineSupportSiteName} field changed
     */
    public IntuneBrand withOnlineSupportSiteName(String onlineSupportSiteName) {
        IntuneBrand _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.intuneBrand");
        _x.onlineSupportSiteName = onlineSupportSiteName;
        return _x;
    }

    /**
     * <i>“URL to the company/organization’s privacy policy.”</i>
     * 
     * @return property privacyUrl
     */
    @Property(name="privacyUrl")
    @JsonIgnore
    public Optional<String> getPrivacyUrl() {
        return Optional.ofNullable(privacyUrl);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code privacyUrl} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“URL to the company/organization’s privacy policy.”</i>
     * 
     * @param privacyUrl
     *            new value of {@code privacyUrl} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code privacyUrl} field changed
     */
    public IntuneBrand withPrivacyUrl(String privacyUrl) {
        IntuneBrand _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.intuneBrand");
        _x.privacyUrl = privacyUrl;
        return _x;
    }

    /**
     * <i>“Custom privacy message.”</i>
     * 
     * @return property customPrivacyMessage
     */
    @Property(name="customPrivacyMessage")
    @JsonIgnore
    public Optional<String> getCustomPrivacyMessage() {
        return Optional.ofNullable(customPrivacyMessage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * customPrivacyMessage} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Custom privacy message.”</i>
     * 
     * @param customPrivacyMessage
     *            new value of {@code customPrivacyMessage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code customPrivacyMessage} field changed
     */
    public IntuneBrand withCustomPrivacyMessage(String customPrivacyMessage) {
        IntuneBrand _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.intuneBrand");
        _x.customPrivacyMessage = customPrivacyMessage;
        return _x;
    }

    /**
     * <i>“Boolean that represents whether the adminsistrator has disabled the 'Remove
     * Device' action on corporate owned devices.”</i>
     * 
     * @return property isRemoveDeviceDisabled
     */
    @Property(name="isRemoveDeviceDisabled")
    @JsonIgnore
    public Optional<Boolean> getIsRemoveDeviceDisabled() {
        return Optional.ofNullable(isRemoveDeviceDisabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * isRemoveDeviceDisabled} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Boolean that represents whether the adminsistrator has disabled the 'Remove
     * Device' action on corporate owned devices.”</i>
     * 
     * @param isRemoveDeviceDisabled
     *            new value of {@code isRemoveDeviceDisabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code isRemoveDeviceDisabled} field changed
     */
    public IntuneBrand withIsRemoveDeviceDisabled(Boolean isRemoveDeviceDisabled) {
        IntuneBrand _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.intuneBrand");
        _x.isRemoveDeviceDisabled = isRemoveDeviceDisabled;
        return _x;
    }

    /**
     * <i>“Boolean that represents whether the adminsistrator has disabled the 'Factory
     * Reset' action on corporate owned devices.”</i>
     * 
     * @return property isFactoryResetDisabled
     */
    @Property(name="isFactoryResetDisabled")
    @JsonIgnore
    public Optional<Boolean> getIsFactoryResetDisabled() {
        return Optional.ofNullable(isFactoryResetDisabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * isFactoryResetDisabled} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Boolean that represents whether the adminsistrator has disabled the 'Factory
     * Reset' action on corporate owned devices.”</i>
     * 
     * @param isFactoryResetDisabled
     *            new value of {@code isFactoryResetDisabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code isFactoryResetDisabled} field changed
     */
    public IntuneBrand withIsFactoryResetDisabled(Boolean isFactoryResetDisabled) {
        IntuneBrand _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.intuneBrand");
        _x.isFactoryResetDisabled = isFactoryResetDisabled;
        return _x;
    }

    /**
     * <i>“Collection of blocked actions on the company portal as per platform and device
     * ownership types.”</i>
     * 
     * @return property companyPortalBlockedActions
     */
    @Property(name="companyPortalBlockedActions")
    @JsonIgnore
    public CollectionPage<CompanyPortalBlockedAction> getCompanyPortalBlockedActions() {
        return new CollectionPage<CompanyPortalBlockedAction>(contextPath, CompanyPortalBlockedAction.class, companyPortalBlockedActions, Optional.ofNullable(companyPortalBlockedActionsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Collection of blocked actions on the company portal as per platform and device
     * ownership types.”</i>
     * 
     * @return property companyPortalBlockedActions
     */
    @Property(name="companyPortalBlockedActions")
    @JsonIgnore
    public CollectionPage<CompanyPortalBlockedAction> getCompanyPortalBlockedActions(HttpRequestOptions options) {
        return new CollectionPage<CompanyPortalBlockedAction>(contextPath, CompanyPortalBlockedAction.class, companyPortalBlockedActions, Optional.ofNullable(companyPortalBlockedActionsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Boolean that indicates if AzureAD Enterprise Apps will be shown in Company
     * Portal”</i>
     * 
     * @return property showAzureADEnterpriseApps
     */
    @Property(name="showAzureADEnterpriseApps")
    @JsonIgnore
    public Optional<Boolean> getShowAzureADEnterpriseApps() {
        return Optional.ofNullable(showAzureADEnterpriseApps);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * showAzureADEnterpriseApps} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Boolean that indicates if AzureAD Enterprise Apps will be shown in Company
     * Portal”</i>
     * 
     * @param showAzureADEnterpriseApps
     *            new value of {@code showAzureADEnterpriseApps} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code showAzureADEnterpriseApps} field changed
     */
    public IntuneBrand withShowAzureADEnterpriseApps(Boolean showAzureADEnterpriseApps) {
        IntuneBrand _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.intuneBrand");
        _x.showAzureADEnterpriseApps = showAzureADEnterpriseApps;
        return _x;
    }

    /**
     * <i>“Boolean that indicates if Office WebApps will be shown in Company Portal”</i>
     * 
     * @return property showOfficeWebApps
     */
    @Property(name="showOfficeWebApps")
    @JsonIgnore
    public Optional<Boolean> getShowOfficeWebApps() {
        return Optional.ofNullable(showOfficeWebApps);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code showOfficeWebApps
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Boolean that indicates if Office WebApps will be shown in Company Portal”</i>
     * 
     * @param showOfficeWebApps
     *            new value of {@code showOfficeWebApps} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code showOfficeWebApps} field changed
     */
    public IntuneBrand withShowOfficeWebApps(Boolean showOfficeWebApps) {
        IntuneBrand _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.intuneBrand");
        _x.showOfficeWebApps = showOfficeWebApps;
        return _x;
    }

    /**
     * <i>“Boolean that indicates if a push notification is sent to users when their device
     * ownership type changes from personal to corporate”</i>
     * 
     * @return property sendDeviceOwnershipChangePushNotification
     */
    @Property(name="sendDeviceOwnershipChangePushNotification")
    @JsonIgnore
    public Optional<Boolean> getSendDeviceOwnershipChangePushNotification() {
        return Optional.ofNullable(sendDeviceOwnershipChangePushNotification);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * sendDeviceOwnershipChangePushNotification} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Boolean that indicates if a push notification is sent to users when their device
     * ownership type changes from personal to corporate”</i>
     * 
     * @param sendDeviceOwnershipChangePushNotification
     *            new value of {@code sendDeviceOwnershipChangePushNotification} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code sendDeviceOwnershipChangePushNotification} field changed
     */
    public IntuneBrand withSendDeviceOwnershipChangePushNotification(Boolean sendDeviceOwnershipChangePushNotification) {
        IntuneBrand _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.intuneBrand");
        _x.sendDeviceOwnershipChangePushNotification = sendDeviceOwnershipChangePushNotification;
        return _x;
    }

    /**
     * <i>“Customized device enrollment flow displayed to the end user”</i>
     * 
     * @return property enrollmentAvailability
     */
    @Property(name="enrollmentAvailability")
    @JsonIgnore
    public Optional<EnrollmentAvailabilityOptions> getEnrollmentAvailability() {
        return Optional.ofNullable(enrollmentAvailability);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * enrollmentAvailability} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Customized device enrollment flow displayed to the end user”</i>
     * 
     * @param enrollmentAvailability
     *            new value of {@code enrollmentAvailability} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enrollmentAvailability} field changed
     */
    public IntuneBrand withEnrollmentAvailability(EnrollmentAvailabilityOptions enrollmentAvailability) {
        IntuneBrand _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.intuneBrand");
        _x.enrollmentAvailability = enrollmentAvailability;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String displayName;
        private RgbColor themeColor;
        private Boolean showLogo;
        private MimeContent lightBackgroundLogo;
        private MimeContent darkBackgroundLogo;
        private Boolean showNameNextToLogo;
        private MimeContent landingPageCustomizedImage;
        private Boolean showDisplayNameNextToLogo;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private String contactITName;
        private String contactITPhoneNumber;
        private String contactITEmailAddress;
        private String contactITNotes;
        private String onlineSupportSiteUrl;
        private String onlineSupportSiteName;
        private String privacyUrl;
        private String customPrivacyMessage;
        private Boolean isRemoveDeviceDisabled;
        private Boolean isFactoryResetDisabled;
        private List<CompanyPortalBlockedAction> companyPortalBlockedActions;
        private String companyPortalBlockedActionsNextLink;
        private Boolean showAzureADEnterpriseApps;
        private Boolean showOfficeWebApps;
        private Boolean sendDeviceOwnershipChangePushNotification;
        private EnrollmentAvailabilityOptions enrollmentAvailability;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Company/organization name that is displayed to end users.”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“Primary theme color used in the Company Portal applications and web portal.”</i>
         * 
         * @param themeColor
         *            value of {@code themeColor} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder themeColor(RgbColor themeColor) {
            this.themeColor = themeColor;
            this.changedFields = changedFields.add("themeColor");
            return this;
        }

        /**
         * <i>“Boolean that represents whether the administrator-supplied logo images are shown
         * or not shown.”</i>
         * 
         * @param showLogo
         *            value of {@code showLogo} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder showLogo(Boolean showLogo) {
            this.showLogo = showLogo;
            this.changedFields = changedFields.add("showLogo");
            return this;
        }

        /**
         * <i>“Logo image displayed in Company Portal apps which have a light background behind
         * the logo.”</i>
         * 
         * @param lightBackgroundLogo
         *            value of {@code lightBackgroundLogo} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lightBackgroundLogo(MimeContent lightBackgroundLogo) {
            this.lightBackgroundLogo = lightBackgroundLogo;
            this.changedFields = changedFields.add("lightBackgroundLogo");
            return this;
        }

        /**
         * <i>“Logo image displayed in Company Portal apps which have a dark background behind
         * the logo.”</i>
         * 
         * @param darkBackgroundLogo
         *            value of {@code darkBackgroundLogo} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder darkBackgroundLogo(MimeContent darkBackgroundLogo) {
            this.darkBackgroundLogo = darkBackgroundLogo;
            this.changedFields = changedFields.add("darkBackgroundLogo");
            return this;
        }

        /**
         * <i>“Boolean that represents whether the administrator-supplied display name will be
         * shown next to the logo image.”</i>
         * 
         * @param showNameNextToLogo
         *            value of {@code showNameNextToLogo} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder showNameNextToLogo(Boolean showNameNextToLogo) {
            this.showNameNextToLogo = showNameNextToLogo;
            this.changedFields = changedFields.add("showNameNextToLogo");
            return this;
        }

        /**
         * <i>“Customized image displayed in Company Portal app landing page”</i>
         * 
         * @param landingPageCustomizedImage
         *            value of {@code landingPageCustomizedImage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder landingPageCustomizedImage(MimeContent landingPageCustomizedImage) {
            this.landingPageCustomizedImage = landingPageCustomizedImage;
            this.changedFields = changedFields.add("landingPageCustomizedImage");
            return this;
        }

        /**
         * <i>“Boolean that represents whether the administrator-supplied display name will be
         * shown next to the logo image.”</i>
         * 
         * @param showDisplayNameNextToLogo
         *            value of {@code showDisplayNameNextToLogo} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder showDisplayNameNextToLogo(Boolean showDisplayNameNextToLogo) {
            this.showDisplayNameNextToLogo = showDisplayNameNextToLogo;
            this.changedFields = changedFields.add("showDisplayNameNextToLogo");
            return this;
        }

        /**
         * <i>“List of scope tags assigned to the default branding profile”</i>
         * 
         * @param roleScopeTagIds
         *            value of {@code roleScopeTagIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        /**
         * <i>“List of scope tags assigned to the default branding profile”</i>
         * 
         * @param roleScopeTagIds
         *            value of {@code roleScopeTagIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        /**
         * <i>“List of scope tags assigned to the default branding profile”</i>
         * 
         * @param roleScopeTagIdsNextLink
         *            value of {@code roleScopeTagIds@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        /**
         * <i>“Name of the person/organization responsible for IT support.”</i>
         * 
         * @param contactITName
         *            value of {@code contactITName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder contactITName(String contactITName) {
            this.contactITName = contactITName;
            this.changedFields = changedFields.add("contactITName");
            return this;
        }

        /**
         * <i>“Phone number of the person/organization responsible for IT support.”</i>
         * 
         * @param contactITPhoneNumber
         *            value of {@code contactITPhoneNumber} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder contactITPhoneNumber(String contactITPhoneNumber) {
            this.contactITPhoneNumber = contactITPhoneNumber;
            this.changedFields = changedFields.add("contactITPhoneNumber");
            return this;
        }

        /**
         * <i>“Email address of the person/organization responsible for IT support.”</i>
         * 
         * @param contactITEmailAddress
         *            value of {@code contactITEmailAddress} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder contactITEmailAddress(String contactITEmailAddress) {
            this.contactITEmailAddress = contactITEmailAddress;
            this.changedFields = changedFields.add("contactITEmailAddress");
            return this;
        }

        /**
         * <i>“Text comments regarding the person/organization responsible for IT support.”</i>
         * 
         * @param contactITNotes
         *            value of {@code contactITNotes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder contactITNotes(String contactITNotes) {
            this.contactITNotes = contactITNotes;
            this.changedFields = changedFields.add("contactITNotes");
            return this;
        }

        /**
         * <i>“URL to the company/organization’s IT helpdesk site.”</i>
         * 
         * @param onlineSupportSiteUrl
         *            value of {@code onlineSupportSiteUrl} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder onlineSupportSiteUrl(String onlineSupportSiteUrl) {
            this.onlineSupportSiteUrl = onlineSupportSiteUrl;
            this.changedFields = changedFields.add("onlineSupportSiteUrl");
            return this;
        }

        /**
         * <i>“Display name of the company/organization’s IT helpdesk site.”</i>
         * 
         * @param onlineSupportSiteName
         *            value of {@code onlineSupportSiteName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder onlineSupportSiteName(String onlineSupportSiteName) {
            this.onlineSupportSiteName = onlineSupportSiteName;
            this.changedFields = changedFields.add("onlineSupportSiteName");
            return this;
        }

        /**
         * <i>“URL to the company/organization’s privacy policy.”</i>
         * 
         * @param privacyUrl
         *            value of {@code privacyUrl} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder privacyUrl(String privacyUrl) {
            this.privacyUrl = privacyUrl;
            this.changedFields = changedFields.add("privacyUrl");
            return this;
        }

        /**
         * <i>“Custom privacy message.”</i>
         * 
         * @param customPrivacyMessage
         *            value of {@code customPrivacyMessage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder customPrivacyMessage(String customPrivacyMessage) {
            this.customPrivacyMessage = customPrivacyMessage;
            this.changedFields = changedFields.add("customPrivacyMessage");
            return this;
        }

        /**
         * <i>“Boolean that represents whether the adminsistrator has disabled the 'Remove
         * Device' action on corporate owned devices.”</i>
         * 
         * @param isRemoveDeviceDisabled
         *            value of {@code isRemoveDeviceDisabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder isRemoveDeviceDisabled(Boolean isRemoveDeviceDisabled) {
            this.isRemoveDeviceDisabled = isRemoveDeviceDisabled;
            this.changedFields = changedFields.add("isRemoveDeviceDisabled");
            return this;
        }

        /**
         * <i>“Boolean that represents whether the adminsistrator has disabled the 'Factory
         * Reset' action on corporate owned devices.”</i>
         * 
         * @param isFactoryResetDisabled
         *            value of {@code isFactoryResetDisabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder isFactoryResetDisabled(Boolean isFactoryResetDisabled) {
            this.isFactoryResetDisabled = isFactoryResetDisabled;
            this.changedFields = changedFields.add("isFactoryResetDisabled");
            return this;
        }

        /**
         * <i>“Collection of blocked actions on the company portal as per platform and device
         * ownership types.”</i>
         * 
         * @param companyPortalBlockedActions
         *            value of {@code companyPortalBlockedActions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder companyPortalBlockedActions(List<CompanyPortalBlockedAction> companyPortalBlockedActions) {
            this.companyPortalBlockedActions = companyPortalBlockedActions;
            this.changedFields = changedFields.add("companyPortalBlockedActions");
            return this;
        }

        /**
         * <i>“Collection of blocked actions on the company portal as per platform and device
         * ownership types.”</i>
         * 
         * @param companyPortalBlockedActions
         *            value of {@code companyPortalBlockedActions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder companyPortalBlockedActions(CompanyPortalBlockedAction... companyPortalBlockedActions) {
            return companyPortalBlockedActions(Arrays.asList(companyPortalBlockedActions));
        }

        /**
         * <i>“Collection of blocked actions on the company portal as per platform and device
         * ownership types.”</i>
         * 
         * @param companyPortalBlockedActionsNextLink
         *            value of {@code companyPortalBlockedActions@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder companyPortalBlockedActionsNextLink(String companyPortalBlockedActionsNextLink) {
            this.companyPortalBlockedActionsNextLink = companyPortalBlockedActionsNextLink;
            this.changedFields = changedFields.add("companyPortalBlockedActions");
            return this;
        }

        /**
         * <i>“Boolean that indicates if AzureAD Enterprise Apps will be shown in Company
         * Portal”</i>
         * 
         * @param showAzureADEnterpriseApps
         *            value of {@code showAzureADEnterpriseApps} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder showAzureADEnterpriseApps(Boolean showAzureADEnterpriseApps) {
            this.showAzureADEnterpriseApps = showAzureADEnterpriseApps;
            this.changedFields = changedFields.add("showAzureADEnterpriseApps");
            return this;
        }

        /**
         * <i>“Boolean that indicates if Office WebApps will be shown in Company Portal”</i>
         * 
         * @param showOfficeWebApps
         *            value of {@code showOfficeWebApps} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder showOfficeWebApps(Boolean showOfficeWebApps) {
            this.showOfficeWebApps = showOfficeWebApps;
            this.changedFields = changedFields.add("showOfficeWebApps");
            return this;
        }

        /**
         * <i>“Boolean that indicates if a push notification is sent to users when their device
         * ownership type changes from personal to corporate”</i>
         * 
         * @param sendDeviceOwnershipChangePushNotification
         *            value of {@code sendDeviceOwnershipChangePushNotification} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder sendDeviceOwnershipChangePushNotification(Boolean sendDeviceOwnershipChangePushNotification) {
            this.sendDeviceOwnershipChangePushNotification = sendDeviceOwnershipChangePushNotification;
            this.changedFields = changedFields.add("sendDeviceOwnershipChangePushNotification");
            return this;
        }

        /**
         * <i>“Customized device enrollment flow displayed to the end user”</i>
         * 
         * @param enrollmentAvailability
         *            value of {@code enrollmentAvailability} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enrollmentAvailability(EnrollmentAvailabilityOptions enrollmentAvailability) {
            this.enrollmentAvailability = enrollmentAvailability;
            this.changedFields = changedFields.add("enrollmentAvailability");
            return this;
        }

        public IntuneBrand build() {
            IntuneBrand _x = new IntuneBrand();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.intuneBrand";
            _x.displayName = displayName;
            _x.themeColor = themeColor;
            _x.showLogo = showLogo;
            _x.lightBackgroundLogo = lightBackgroundLogo;
            _x.darkBackgroundLogo = darkBackgroundLogo;
            _x.showNameNextToLogo = showNameNextToLogo;
            _x.landingPageCustomizedImage = landingPageCustomizedImage;
            _x.showDisplayNameNextToLogo = showDisplayNameNextToLogo;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.contactITName = contactITName;
            _x.contactITPhoneNumber = contactITPhoneNumber;
            _x.contactITEmailAddress = contactITEmailAddress;
            _x.contactITNotes = contactITNotes;
            _x.onlineSupportSiteUrl = onlineSupportSiteUrl;
            _x.onlineSupportSiteName = onlineSupportSiteName;
            _x.privacyUrl = privacyUrl;
            _x.customPrivacyMessage = customPrivacyMessage;
            _x.isRemoveDeviceDisabled = isRemoveDeviceDisabled;
            _x.isFactoryResetDisabled = isFactoryResetDisabled;
            _x.companyPortalBlockedActions = companyPortalBlockedActions;
            _x.companyPortalBlockedActionsNextLink = companyPortalBlockedActionsNextLink;
            _x.showAzureADEnterpriseApps = showAzureADEnterpriseApps;
            _x.showOfficeWebApps = showOfficeWebApps;
            _x.sendDeviceOwnershipChangePushNotification = sendDeviceOwnershipChangePushNotification;
            _x.enrollmentAvailability = enrollmentAvailability;
            return _x;
        }
    }

    private IntuneBrand _copy() {
        IntuneBrand _x = new IntuneBrand();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.displayName = displayName;
        _x.themeColor = themeColor;
        _x.showLogo = showLogo;
        _x.lightBackgroundLogo = lightBackgroundLogo;
        _x.darkBackgroundLogo = darkBackgroundLogo;
        _x.showNameNextToLogo = showNameNextToLogo;
        _x.landingPageCustomizedImage = landingPageCustomizedImage;
        _x.showDisplayNameNextToLogo = showDisplayNameNextToLogo;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.contactITName = contactITName;
        _x.contactITPhoneNumber = contactITPhoneNumber;
        _x.contactITEmailAddress = contactITEmailAddress;
        _x.contactITNotes = contactITNotes;
        _x.onlineSupportSiteUrl = onlineSupportSiteUrl;
        _x.onlineSupportSiteName = onlineSupportSiteName;
        _x.privacyUrl = privacyUrl;
        _x.customPrivacyMessage = customPrivacyMessage;
        _x.isRemoveDeviceDisabled = isRemoveDeviceDisabled;
        _x.isFactoryResetDisabled = isFactoryResetDisabled;
        _x.companyPortalBlockedActions = companyPortalBlockedActions;
        _x.showAzureADEnterpriseApps = showAzureADEnterpriseApps;
        _x.showOfficeWebApps = showOfficeWebApps;
        _x.sendDeviceOwnershipChangePushNotification = sendDeviceOwnershipChangePushNotification;
        _x.enrollmentAvailability = enrollmentAvailability;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("IntuneBrand[");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("themeColor=");
        b.append(this.themeColor);
        b.append(", ");
        b.append("showLogo=");
        b.append(this.showLogo);
        b.append(", ");
        b.append("lightBackgroundLogo=");
        b.append(this.lightBackgroundLogo);
        b.append(", ");
        b.append("darkBackgroundLogo=");
        b.append(this.darkBackgroundLogo);
        b.append(", ");
        b.append("showNameNextToLogo=");
        b.append(this.showNameNextToLogo);
        b.append(", ");
        b.append("landingPageCustomizedImage=");
        b.append(this.landingPageCustomizedImage);
        b.append(", ");
        b.append("showDisplayNameNextToLogo=");
        b.append(this.showDisplayNameNextToLogo);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("contactITName=");
        b.append(this.contactITName);
        b.append(", ");
        b.append("contactITPhoneNumber=");
        b.append(this.contactITPhoneNumber);
        b.append(", ");
        b.append("contactITEmailAddress=");
        b.append(this.contactITEmailAddress);
        b.append(", ");
        b.append("contactITNotes=");
        b.append(this.contactITNotes);
        b.append(", ");
        b.append("onlineSupportSiteUrl=");
        b.append(this.onlineSupportSiteUrl);
        b.append(", ");
        b.append("onlineSupportSiteName=");
        b.append(this.onlineSupportSiteName);
        b.append(", ");
        b.append("privacyUrl=");
        b.append(this.privacyUrl);
        b.append(", ");
        b.append("customPrivacyMessage=");
        b.append(this.customPrivacyMessage);
        b.append(", ");
        b.append("isRemoveDeviceDisabled=");
        b.append(this.isRemoveDeviceDisabled);
        b.append(", ");
        b.append("isFactoryResetDisabled=");
        b.append(this.isFactoryResetDisabled);
        b.append(", ");
        b.append("companyPortalBlockedActions=");
        b.append(this.companyPortalBlockedActions);
        b.append(", ");
        b.append("showAzureADEnterpriseApps=");
        b.append(this.showAzureADEnterpriseApps);
        b.append(", ");
        b.append("showOfficeWebApps=");
        b.append(this.showOfficeWebApps);
        b.append(", ");
        b.append("sendDeviceOwnershipChangePushNotification=");
        b.append(this.sendDeviceOwnershipChangePushNotification);
        b.append(", ");
        b.append("enrollmentAvailability=");
        b.append(this.enrollmentAvailability);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
