package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "resourceAppId", 
    "permissions"})
@JsonInclude(Include.NON_NULL)
public class InstanceResourceAccess implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("resourceAppId")
    protected String resourceAppId;

    @JsonProperty("permissions")
    protected List<ResourcePermission> permissions;

    @JsonProperty("permissions@nextLink")
    protected String permissionsNextLink;

    protected InstanceResourceAccess() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.instanceResourceAccess";
    }

    @Property(name="resourceAppId")
    @JsonIgnore
    public Optional<String> getResourceAppId() {
        return Optional.ofNullable(resourceAppId);
    }

    public InstanceResourceAccess withResourceAppId(String resourceAppId) {
        InstanceResourceAccess _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.instanceResourceAccess");
        _x.resourceAppId = resourceAppId;
        return _x;
    }

    @Property(name="permissions")
    @JsonIgnore
    public CollectionPage<ResourcePermission> getPermissions() {
        return new CollectionPage<ResourcePermission>(contextPath, ResourcePermission.class, permissions, Optional.ofNullable(permissionsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="permissions")
    @JsonIgnore
    public CollectionPage<ResourcePermission> getPermissions(HttpRequestOptions options) {
        return new CollectionPage<ResourcePermission>(contextPath, ResourcePermission.class, permissions, Optional.ofNullable(permissionsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String resourceAppId;
        private List<ResourcePermission> permissions;
        private String permissionsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder resourceAppId(String resourceAppId) {
            this.resourceAppId = resourceAppId;
            this.changedFields = changedFields.add("resourceAppId");
            return this;
        }

        public Builder permissions(List<ResourcePermission> permissions) {
            this.permissions = permissions;
            this.changedFields = changedFields.add("permissions");
            return this;
        }

        public Builder permissions(ResourcePermission... permissions) {
            return permissions(Arrays.asList(permissions));
        }

        public Builder permissionsNextLink(String permissionsNextLink) {
            this.permissionsNextLink = permissionsNextLink;
            this.changedFields = changedFields.add("permissions");
            return this;
        }

        public InstanceResourceAccess build() {
            InstanceResourceAccess _x = new InstanceResourceAccess();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.instanceResourceAccess";
            _x.resourceAppId = resourceAppId;
            _x.permissions = permissions;
            _x.permissionsNextLink = permissionsNextLink;
            return _x;
        }
    }

    private InstanceResourceAccess _copy() {
        InstanceResourceAccess _x = new InstanceResourceAccess();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.resourceAppId = resourceAppId;
        _x.permissions = permissions;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("InstanceResourceAccess[");
        b.append("resourceAppId=");
        b.append(this.resourceAppId);
        b.append(", ");
        b.append("permissions=");
        b.append(this.permissions);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
