package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


/**
 * <i>“The value in an user experience analytics insight.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "value"})
@JsonInclude(Include.NON_NULL)
public class InsightValueInt extends UserExperienceAnalyticsInsightValue implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("value")
    protected Integer value;

    protected InsightValueInt() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.insightValueInt";
    }

    @Property(name="value")
    @JsonIgnore
    public Optional<Integer> getValue() {
        return Optional.ofNullable(value);
    }

    public InsightValueInt withValue(Integer value) {
        InsightValueInt _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.insightValueInt");
        _x.value = value;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderInsightValueInt() {
        return new Builder();
    }

    public static final class Builder {
        private Integer value;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder value(Integer value) {
            this.value = value;
            this.changedFields = changedFields.add("value");
            return this;
        }

        public InsightValueInt build() {
            InsightValueInt _x = new InsightValueInt();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.insightValueInt";
            _x.value = value;
            return _x;
        }
    }

    private InsightValueInt _copy() {
        InsightValueInt _x = new InsightValueInt();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.value = value;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("InsightValueInt[");
        b.append("value=");
        b.append(this.value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
