package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "source", 
    "message"})
@JsonInclude(Include.NON_NULL)
public class InnerErrorDetail implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("source")
    protected String source;

    @JsonProperty("message")
    protected String message;

    protected InnerErrorDetail() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.innerErrorDetail";
    }

    @Property(name="source")
    @JsonIgnore
    public Optional<String> getSource() {
        return Optional.ofNullable(source);
    }

    public InnerErrorDetail withSource(String source) {
        InnerErrorDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.innerErrorDetail");
        _x.source = source;
        return _x;
    }

    @Property(name="message")
    @JsonIgnore
    public Optional<String> getMessage() {
        return Optional.ofNullable(message);
    }

    public InnerErrorDetail withMessage(String message) {
        InnerErrorDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.innerErrorDetail");
        _x.message = message;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String source;
        private String message;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder source(String source) {
            this.source = source;
            this.changedFields = changedFields.add("source");
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            this.changedFields = changedFields.add("message");
            return this;
        }

        public InnerErrorDetail build() {
            InnerErrorDetail _x = new InnerErrorDetail();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.innerErrorDetail";
            _x.source = source;
            _x.message = message;
            return _x;
        }
    }

    private InnerErrorDetail _copy() {
        InnerErrorDetail _x = new InnerErrorDetail();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.source = source;
        _x.message = message;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("InnerErrorDetail[");
        b.append("source=");
        b.append(this.source);
        b.append(", ");
        b.append("message=");
        b.append(this.message);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
