package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.InitiatorType;

@JsonPropertyOrder({
    "@odata.type", 
    "id", 
    "displayName", 
    "initiatorType"})
@JsonInclude(Include.NON_NULL)
public class Initiator implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("id")
    protected String id;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("initiatorType")
    protected InitiatorType initiatorType;

    protected Initiator() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.initiator";
    }

    @Property(name="id")
    @JsonIgnore
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    public Initiator withId(String id) {
        Initiator _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.initiator");
        _x.id = id;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public Initiator withDisplayName(String displayName) {
        Initiator _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.initiator");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="initiatorType")
    @JsonIgnore
    public Optional<InitiatorType> getInitiatorType() {
        return Optional.ofNullable(initiatorType);
    }

    public Initiator withInitiatorType(InitiatorType initiatorType) {
        Initiator _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.initiator");
        _x.initiatorType = initiatorType;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private InitiatorType initiatorType;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder initiatorType(InitiatorType initiatorType) {
            this.initiatorType = initiatorType;
            this.changedFields = changedFields.add("initiatorType");
            return this;
        }

        public Initiator build() {
            Initiator _x = new Initiator();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.initiator";
            _x.id = id;
            _x.displayName = displayName;
            _x.initiatorType = initiatorType;
            return _x;
        }
    }

    private Initiator _copy() {
        Initiator _x = new Initiator();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.initiatorType = initiatorType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Initiator[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("initiatorType=");
        b.append(this.initiatorType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
