package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.AssignmentMethod;

@JsonPropertyOrder({
    "@odata.type", 
    "creationDateTime", 
    "assignmentMethod", 
    "label"})
@JsonInclude(Include.NON_NULL)
public class InformationProtectionContentLabel implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("creationDateTime")
    protected OffsetDateTime creationDateTime;

    @JsonProperty("assignmentMethod")
    protected AssignmentMethod assignmentMethod;

    @JsonProperty("label")
    protected LabelDetails label;

    protected InformationProtectionContentLabel() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.informationProtectionContentLabel";
    }

    @Property(name="creationDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreationDateTime() {
        return Optional.ofNullable(creationDateTime);
    }

    public InformationProtectionContentLabel withCreationDateTime(OffsetDateTime creationDateTime) {
        InformationProtectionContentLabel _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.informationProtectionContentLabel");
        _x.creationDateTime = creationDateTime;
        return _x;
    }

    @Property(name="assignmentMethod")
    @JsonIgnore
    public Optional<AssignmentMethod> getAssignmentMethod() {
        return Optional.ofNullable(assignmentMethod);
    }

    public InformationProtectionContentLabel withAssignmentMethod(AssignmentMethod assignmentMethod) {
        InformationProtectionContentLabel _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.informationProtectionContentLabel");
        _x.assignmentMethod = assignmentMethod;
        return _x;
    }

    @Property(name="label")
    @JsonIgnore
    public Optional<LabelDetails> getLabel() {
        return Optional.ofNullable(label);
    }

    public InformationProtectionContentLabel withLabel(LabelDetails label) {
        InformationProtectionContentLabel _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.informationProtectionContentLabel");
        _x.label = label;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime creationDateTime;
        private AssignmentMethod assignmentMethod;
        private LabelDetails label;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder creationDateTime(OffsetDateTime creationDateTime) {
            this.creationDateTime = creationDateTime;
            this.changedFields = changedFields.add("creationDateTime");
            return this;
        }

        public Builder assignmentMethod(AssignmentMethod assignmentMethod) {
            this.assignmentMethod = assignmentMethod;
            this.changedFields = changedFields.add("assignmentMethod");
            return this;
        }

        public Builder label(LabelDetails label) {
            this.label = label;
            this.changedFields = changedFields.add("label");
            return this;
        }

        public InformationProtectionContentLabel build() {
            InformationProtectionContentLabel _x = new InformationProtectionContentLabel();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.informationProtectionContentLabel";
            _x.creationDateTime = creationDateTime;
            _x.assignmentMethod = assignmentMethod;
            _x.label = label;
            return _x;
        }
    }

    private InformationProtectionContentLabel _copy() {
        InformationProtectionContentLabel _x = new InformationProtectionContentLabel();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.creationDateTime = creationDateTime;
        _x.assignmentMethod = assignmentMethod;
        _x.label = label;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("InformationProtectionContentLabel[");
        b.append("creationDateTime=");
        b.append(this.creationDateTime);
        b.append(", ");
        b.append("assignmentMethod=");
        b.append(this.assignmentMethod);
        b.append(", ");
        b.append("label=");
        b.append(this.label);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
