package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "sourceParticipantId", 
    "observedParticipantId", 
    "onBehalfOf", 
    "transferor"})
@JsonInclude(Include.NON_NULL)
public class IncomingContext implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("sourceParticipantId")
    protected String sourceParticipantId;

    @JsonProperty("observedParticipantId")
    protected String observedParticipantId;

    @JsonProperty("onBehalfOf")
    protected IdentitySet onBehalfOf;

    @JsonProperty("transferor")
    protected IdentitySet transferor;

    protected IncomingContext() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.incomingContext";
    }

    @Property(name="sourceParticipantId")
    @JsonIgnore
    public Optional<String> getSourceParticipantId() {
        return Optional.ofNullable(sourceParticipantId);
    }

    public IncomingContext withSourceParticipantId(String sourceParticipantId) {
        IncomingContext _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.incomingContext");
        _x.sourceParticipantId = sourceParticipantId;
        return _x;
    }

    @Property(name="observedParticipantId")
    @JsonIgnore
    public Optional<String> getObservedParticipantId() {
        return Optional.ofNullable(observedParticipantId);
    }

    public IncomingContext withObservedParticipantId(String observedParticipantId) {
        IncomingContext _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.incomingContext");
        _x.observedParticipantId = observedParticipantId;
        return _x;
    }

    @Property(name="onBehalfOf")
    @JsonIgnore
    public Optional<IdentitySet> getOnBehalfOf() {
        return Optional.ofNullable(onBehalfOf);
    }

    public IncomingContext withOnBehalfOf(IdentitySet onBehalfOf) {
        IncomingContext _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.incomingContext");
        _x.onBehalfOf = onBehalfOf;
        return _x;
    }

    @Property(name="transferor")
    @JsonIgnore
    public Optional<IdentitySet> getTransferor() {
        return Optional.ofNullable(transferor);
    }

    public IncomingContext withTransferor(IdentitySet transferor) {
        IncomingContext _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.incomingContext");
        _x.transferor = transferor;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String sourceParticipantId;
        private String observedParticipantId;
        private IdentitySet onBehalfOf;
        private IdentitySet transferor;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder sourceParticipantId(String sourceParticipantId) {
            this.sourceParticipantId = sourceParticipantId;
            this.changedFields = changedFields.add("sourceParticipantId");
            return this;
        }

        public Builder observedParticipantId(String observedParticipantId) {
            this.observedParticipantId = observedParticipantId;
            this.changedFields = changedFields.add("observedParticipantId");
            return this;
        }

        public Builder onBehalfOf(IdentitySet onBehalfOf) {
            this.onBehalfOf = onBehalfOf;
            this.changedFields = changedFields.add("onBehalfOf");
            return this;
        }

        public Builder transferor(IdentitySet transferor) {
            this.transferor = transferor;
            this.changedFields = changedFields.add("transferor");
            return this;
        }

        public IncomingContext build() {
            IncomingContext _x = new IncomingContext();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.incomingContext";
            _x.sourceParticipantId = sourceParticipantId;
            _x.observedParticipantId = observedParticipantId;
            _x.onBehalfOf = onBehalfOf;
            _x.transferor = transferor;
            return _x;
        }
    }

    private IncomingContext _copy() {
        IncomingContext _x = new IncomingContext();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.sourceParticipantId = sourceParticipantId;
        _x.observedParticipantId = observedParticipantId;
        _x.onBehalfOf = onBehalfOf;
        _x.transferor = transferor;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("IncomingContext[");
        b.append("sourceParticipantId=");
        b.append(this.sourceParticipantId);
        b.append(", ");
        b.append("observedParticipantId=");
        b.append(this.observedParticipantId);
        b.append(", ");
        b.append("onBehalfOf=");
        b.append(this.onBehalfOf);
        b.append(", ");
        b.append("transferor=");
        b.append(this.transferor);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
