package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.ImportedWindowsAutopilotDeviceIdentityImportStatus;

@JsonPropertyOrder({
    "@odata.type", 
    "deviceImportStatus", 
    "deviceRegistrationId", 
    "deviceErrorCode", 
    "deviceErrorName"})
@JsonInclude(Include.NON_NULL)
public class ImportedWindowsAutopilotDeviceIdentityState implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("deviceImportStatus")
    protected ImportedWindowsAutopilotDeviceIdentityImportStatus deviceImportStatus;

    @JsonProperty("deviceRegistrationId")
    protected String deviceRegistrationId;

    @JsonProperty("deviceErrorCode")
    protected Integer deviceErrorCode;

    @JsonProperty("deviceErrorName")
    protected String deviceErrorName;

    protected ImportedWindowsAutopilotDeviceIdentityState() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.importedWindowsAutopilotDeviceIdentityState";
    }

    /**
     * <i>“Device status reported by Device Directory Service(DDS).”</i>
     * 
     * @return property deviceImportStatus
     */
    @Property(name="deviceImportStatus")
    @JsonIgnore
    public Optional<ImportedWindowsAutopilotDeviceIdentityImportStatus> getDeviceImportStatus() {
        return Optional.ofNullable(deviceImportStatus);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceImportStatus} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Device status reported by Device Directory Service(DDS).”</i>
     * 
     * @param deviceImportStatus
     *            new value of {@code deviceImportStatus} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceImportStatus} field changed
     */
    public ImportedWindowsAutopilotDeviceIdentityState withDeviceImportStatus(ImportedWindowsAutopilotDeviceIdentityImportStatus deviceImportStatus) {
        ImportedWindowsAutopilotDeviceIdentityState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.importedWindowsAutopilotDeviceIdentityState");
        _x.deviceImportStatus = deviceImportStatus;
        return _x;
    }

    /**
     * <i>“Device Registration ID for successfully added device reported by Device
     * Directory Service(DDS).”</i>
     * 
     * @return property deviceRegistrationId
     */
    @Property(name="deviceRegistrationId")
    @JsonIgnore
    public Optional<String> getDeviceRegistrationId() {
        return Optional.ofNullable(deviceRegistrationId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceRegistrationId} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Device Registration ID for successfully added device reported by Device
     * Directory Service(DDS).”</i>
     * 
     * @param deviceRegistrationId
     *            new value of {@code deviceRegistrationId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceRegistrationId} field changed
     */
    public ImportedWindowsAutopilotDeviceIdentityState withDeviceRegistrationId(String deviceRegistrationId) {
        ImportedWindowsAutopilotDeviceIdentityState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.importedWindowsAutopilotDeviceIdentityState");
        _x.deviceRegistrationId = deviceRegistrationId;
        return _x;
    }

    /**
     * <i>“Device error code reported by Device Directory Service(DDS).”</i>
     * 
     * @return property deviceErrorCode
     */
    @Property(name="deviceErrorCode")
    @JsonIgnore
    public Optional<Integer> getDeviceErrorCode() {
        return Optional.ofNullable(deviceErrorCode);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceErrorCode}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Device error code reported by Device Directory Service(DDS).”</i>
     * 
     * @param deviceErrorCode
     *            new value of {@code deviceErrorCode} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceErrorCode} field changed
     */
    public ImportedWindowsAutopilotDeviceIdentityState withDeviceErrorCode(Integer deviceErrorCode) {
        ImportedWindowsAutopilotDeviceIdentityState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.importedWindowsAutopilotDeviceIdentityState");
        _x.deviceErrorCode = deviceErrorCode;
        return _x;
    }

    /**
     * <i>“Device error name reported by Device Directory Service(DDS).”</i>
     * 
     * @return property deviceErrorName
     */
    @Property(name="deviceErrorName")
    @JsonIgnore
    public Optional<String> getDeviceErrorName() {
        return Optional.ofNullable(deviceErrorName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceErrorName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Device error name reported by Device Directory Service(DDS).”</i>
     * 
     * @param deviceErrorName
     *            new value of {@code deviceErrorName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceErrorName} field changed
     */
    public ImportedWindowsAutopilotDeviceIdentityState withDeviceErrorName(String deviceErrorName) {
        ImportedWindowsAutopilotDeviceIdentityState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.importedWindowsAutopilotDeviceIdentityState");
        _x.deviceErrorName = deviceErrorName;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ImportedWindowsAutopilotDeviceIdentityImportStatus deviceImportStatus;
        private String deviceRegistrationId;
        private Integer deviceErrorCode;
        private String deviceErrorName;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Device status reported by Device Directory Service(DDS).”</i>
         * 
         * @param deviceImportStatus
         *            value of {@code deviceImportStatus} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceImportStatus(ImportedWindowsAutopilotDeviceIdentityImportStatus deviceImportStatus) {
            this.deviceImportStatus = deviceImportStatus;
            this.changedFields = changedFields.add("deviceImportStatus");
            return this;
        }

        /**
         * <i>“Device Registration ID for successfully added device reported by Device
         * Directory Service(DDS).”</i>
         * 
         * @param deviceRegistrationId
         *            value of {@code deviceRegistrationId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceRegistrationId(String deviceRegistrationId) {
            this.deviceRegistrationId = deviceRegistrationId;
            this.changedFields = changedFields.add("deviceRegistrationId");
            return this;
        }

        /**
         * <i>“Device error code reported by Device Directory Service(DDS).”</i>
         * 
         * @param deviceErrorCode
         *            value of {@code deviceErrorCode} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceErrorCode(Integer deviceErrorCode) {
            this.deviceErrorCode = deviceErrorCode;
            this.changedFields = changedFields.add("deviceErrorCode");
            return this;
        }

        /**
         * <i>“Device error name reported by Device Directory Service(DDS).”</i>
         * 
         * @param deviceErrorName
         *            value of {@code deviceErrorName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceErrorName(String deviceErrorName) {
            this.deviceErrorName = deviceErrorName;
            this.changedFields = changedFields.add("deviceErrorName");
            return this;
        }

        public ImportedWindowsAutopilotDeviceIdentityState build() {
            ImportedWindowsAutopilotDeviceIdentityState _x = new ImportedWindowsAutopilotDeviceIdentityState();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.importedWindowsAutopilotDeviceIdentityState";
            _x.deviceImportStatus = deviceImportStatus;
            _x.deviceRegistrationId = deviceRegistrationId;
            _x.deviceErrorCode = deviceErrorCode;
            _x.deviceErrorName = deviceErrorName;
            return _x;
        }
    }

    private ImportedWindowsAutopilotDeviceIdentityState _copy() {
        ImportedWindowsAutopilotDeviceIdentityState _x = new ImportedWindowsAutopilotDeviceIdentityState();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.deviceImportStatus = deviceImportStatus;
        _x.deviceRegistrationId = deviceRegistrationId;
        _x.deviceErrorCode = deviceErrorCode;
        _x.deviceErrorName = deviceErrorName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ImportedWindowsAutopilotDeviceIdentityState[");
        b.append("deviceImportStatus=");
        b.append(this.deviceImportStatus);
        b.append(", ");
        b.append("deviceRegistrationId=");
        b.append(this.deviceRegistrationId);
        b.append(", ");
        b.append("deviceErrorCode=");
        b.append(this.deviceErrorCode);
        b.append(", ");
        b.append("deviceErrorName=");
        b.append(this.deviceErrorName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
