package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "iconUrl", 
    "alternativeText", 
    "alternateText", 
    "addImageQuery"})
@JsonInclude(Include.NON_NULL)
public class ImageInfo implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("iconUrl")
    protected String iconUrl;

    @JsonProperty("alternativeText")
    protected String alternativeText;

    @JsonProperty("alternateText")
    protected String alternateText;

    @JsonProperty("addImageQuery")
    protected Boolean addImageQuery;

    protected ImageInfo() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.imageInfo";
    }

    @Property(name="iconUrl")
    @JsonIgnore
    public Optional<String> getIconUrl() {
        return Optional.ofNullable(iconUrl);
    }

    public ImageInfo withIconUrl(String iconUrl) {
        ImageInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.imageInfo");
        _x.iconUrl = iconUrl;
        return _x;
    }

    @Property(name="alternativeText")
    @JsonIgnore
    public Optional<String> getAlternativeText() {
        return Optional.ofNullable(alternativeText);
    }

    public ImageInfo withAlternativeText(String alternativeText) {
        ImageInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.imageInfo");
        _x.alternativeText = alternativeText;
        return _x;
    }

    @Property(name="alternateText")
    @JsonIgnore
    public Optional<String> getAlternateText() {
        return Optional.ofNullable(alternateText);
    }

    public ImageInfo withAlternateText(String alternateText) {
        ImageInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.imageInfo");
        _x.alternateText = alternateText;
        return _x;
    }

    @Property(name="addImageQuery")
    @JsonIgnore
    public Optional<Boolean> getAddImageQuery() {
        return Optional.ofNullable(addImageQuery);
    }

    public ImageInfo withAddImageQuery(Boolean addImageQuery) {
        ImageInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.imageInfo");
        _x.addImageQuery = addImageQuery;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String iconUrl;
        private String alternativeText;
        private String alternateText;
        private Boolean addImageQuery;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder iconUrl(String iconUrl) {
            this.iconUrl = iconUrl;
            this.changedFields = changedFields.add("iconUrl");
            return this;
        }

        public Builder alternativeText(String alternativeText) {
            this.alternativeText = alternativeText;
            this.changedFields = changedFields.add("alternativeText");
            return this;
        }

        public Builder alternateText(String alternateText) {
            this.alternateText = alternateText;
            this.changedFields = changedFields.add("alternateText");
            return this;
        }

        public Builder addImageQuery(Boolean addImageQuery) {
            this.addImageQuery = addImageQuery;
            this.changedFields = changedFields.add("addImageQuery");
            return this;
        }

        public ImageInfo build() {
            ImageInfo _x = new ImageInfo();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.imageInfo";
            _x.iconUrl = iconUrl;
            _x.alternativeText = alternativeText;
            _x.alternateText = alternateText;
            _x.addImageQuery = addImageQuery;
            return _x;
        }
    }

    private ImageInfo _copy() {
        ImageInfo _x = new ImageInfo();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.iconUrl = iconUrl;
        _x.alternativeText = alternativeText;
        _x.alternateText = alternateText;
        _x.addImageQuery = addImageQuery;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ImageInfo[");
        b.append("iconUrl=");
        b.append(this.iconUrl);
        b.append(", ");
        b.append("alternativeText=");
        b.append(this.alternativeText);
        b.append(", ");
        b.append("alternateText=");
        b.append(this.alternateText);
        b.append(", ");
        b.append("addImageQuery=");
        b.append(this.addImageQuery);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
