package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "application", 
    "device", 
    "user"})
@JsonInclude(Include.NON_NULL)
public class IdentitySet implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("application")
    protected Identity application;

    @JsonProperty("device")
    protected Identity device;

    @JsonProperty("user")
    protected Identity user;

    protected IdentitySet() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.identitySet";
    }

    @Property(name="application")
    @JsonIgnore
    public Optional<Identity> getApplication() {
        return Optional.ofNullable(application);
    }

    public IdentitySet withApplication(Identity application) {
        IdentitySet _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.identitySet");
        _x.application = application;
        return _x;
    }

    @Property(name="device")
    @JsonIgnore
    public Optional<Identity> getDevice() {
        return Optional.ofNullable(device);
    }

    public IdentitySet withDevice(Identity device) {
        IdentitySet _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.identitySet");
        _x.device = device;
        return _x;
    }

    @Property(name="user")
    @JsonIgnore
    public Optional<Identity> getUser() {
        return Optional.ofNullable(user);
    }

    public IdentitySet withUser(Identity user) {
        IdentitySet _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.identitySet");
        _x.user = user;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Identity application;
        private Identity device;
        private Identity user;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder application(Identity application) {
            this.application = application;
            this.changedFields = changedFields.add("application");
            return this;
        }

        public Builder device(Identity device) {
            this.device = device;
            this.changedFields = changedFields.add("device");
            return this;
        }

        public Builder user(Identity user) {
            this.user = user;
            this.changedFields = changedFields.add("user");
            return this;
        }

        public IdentitySet build() {
            IdentitySet _x = new IdentitySet();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.identitySet";
            _x.application = application;
            _x.device = device;
            _x.user = user;
            return _x;
        }
    }

    private IdentitySet _copy() {
        IdentitySet _x = new IdentitySet();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.application = application;
        _x.device = device;
        _x.user = user;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("IdentitySet[");
        b.append("application=");
        b.append(this.application);
        b.append(", ");
        b.append("device=");
        b.append(this.device);
        b.append(", ");
        b.append("user=");
        b.append(this.user);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
