package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "cidrAddress"})
@JsonInclude(Include.NON_NULL)
public class IPv4CidrRange extends IpRange implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("cidrAddress")
    protected String cidrAddress;

    protected IPv4CidrRange() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.iPv4CidrRange";
    }

    @Property(name="cidrAddress")
    @JsonIgnore
    public Optional<String> getCidrAddress() {
        return Optional.ofNullable(cidrAddress);
    }

    public IPv4CidrRange withCidrAddress(String cidrAddress) {
        IPv4CidrRange _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.iPv4CidrRange");
        _x.cidrAddress = cidrAddress;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderIPv4CidrRange() {
        return new Builder();
    }

    public static final class Builder {
        private String cidrAddress;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder cidrAddress(String cidrAddress) {
            this.cidrAddress = cidrAddress;
            this.changedFields = changedFields.add("cidrAddress");
            return this;
        }

        public IPv4CidrRange build() {
            IPv4CidrRange _x = new IPv4CidrRange();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.iPv4CidrRange";
            _x.cidrAddress = cidrAddress;
            return _x;
        }
    }

    private IPv4CidrRange _copy() {
        IPv4CidrRange _x = new IPv4CidrRange();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.cidrAddress = cidrAddress;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("IPv4CidrRange[");
        b.append("cidrAddress=");
        b.append(this.cidrAddress);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
