package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "crc32Hash", 
    "quickXorHash", 
    "sha1Hash", 
    "sha256Hash"})
@JsonInclude(Include.NON_NULL)
public class Hashes implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("crc32Hash")
    protected String crc32Hash;

    @JsonProperty("quickXorHash")
    protected String quickXorHash;

    @JsonProperty("sha1Hash")
    protected String sha1Hash;

    @JsonProperty("sha256Hash")
    protected String sha256Hash;

    protected Hashes() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.hashes";
    }

    @Property(name="crc32Hash")
    @JsonIgnore
    public Optional<String> getCrc32Hash() {
        return Optional.ofNullable(crc32Hash);
    }

    public Hashes withCrc32Hash(String crc32Hash) {
        Hashes _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hashes");
        _x.crc32Hash = crc32Hash;
        return _x;
    }

    @Property(name="quickXorHash")
    @JsonIgnore
    public Optional<String> getQuickXorHash() {
        return Optional.ofNullable(quickXorHash);
    }

    public Hashes withQuickXorHash(String quickXorHash) {
        Hashes _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hashes");
        _x.quickXorHash = quickXorHash;
        return _x;
    }

    @Property(name="sha1Hash")
    @JsonIgnore
    public Optional<String> getSha1Hash() {
        return Optional.ofNullable(sha1Hash);
    }

    public Hashes withSha1Hash(String sha1Hash) {
        Hashes _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hashes");
        _x.sha1Hash = sha1Hash;
        return _x;
    }

    @Property(name="sha256Hash")
    @JsonIgnore
    public Optional<String> getSha256Hash() {
        return Optional.ofNullable(sha256Hash);
    }

    public Hashes withSha256Hash(String sha256Hash) {
        Hashes _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hashes");
        _x.sha256Hash = sha256Hash;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String crc32Hash;
        private String quickXorHash;
        private String sha1Hash;
        private String sha256Hash;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder crc32Hash(String crc32Hash) {
            this.crc32Hash = crc32Hash;
            this.changedFields = changedFields.add("crc32Hash");
            return this;
        }

        public Builder quickXorHash(String quickXorHash) {
            this.quickXorHash = quickXorHash;
            this.changedFields = changedFields.add("quickXorHash");
            return this;
        }

        public Builder sha1Hash(String sha1Hash) {
            this.sha1Hash = sha1Hash;
            this.changedFields = changedFields.add("sha1Hash");
            return this;
        }

        public Builder sha256Hash(String sha256Hash) {
            this.sha256Hash = sha256Hash;
            this.changedFields = changedFields.add("sha256Hash");
            return this;
        }

        public Hashes build() {
            Hashes _x = new Hashes();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.hashes";
            _x.crc32Hash = crc32Hash;
            _x.quickXorHash = quickXorHash;
            _x.sha1Hash = sha1Hash;
            _x.sha256Hash = sha256Hash;
            return _x;
        }
    }

    private Hashes _copy() {
        Hashes _x = new Hashes();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.crc32Hash = crc32Hash;
        _x.quickXorHash = quickXorHash;
        _x.sha1Hash = sha1Hash;
        _x.sha256Hash = sha256Hash;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Hashes[");
        b.append("crc32Hash=");
        b.append(this.crc32Hash);
        b.append(", ");
        b.append("quickXorHash=");
        b.append(this.quickXorHash);
        b.append(", ");
        b.append("sha1Hash=");
        b.append(this.sha1Hash);
        b.append(", ");
        b.append("sha256Hash=");
        b.append(this.sha256Hash);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
