package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.DeviceAndAppManagementAssignmentSource;
import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <i>“A class containing the result of HasPayloadLinks action.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "payloadId", 
    "hasLink", 
    "error", 
    "sources"})
@JsonInclude(Include.NON_NULL)
public class HasPayloadLinkResultItem implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("payloadId")
    protected String payloadId;

    @JsonProperty("hasLink")
    protected Boolean hasLink;

    @JsonProperty("error")
    protected String error;

    @JsonProperty("sources")
    protected List<DeviceAndAppManagementAssignmentSource> sources;

    @JsonProperty("sources@nextLink")
    protected String sourcesNextLink;

    protected HasPayloadLinkResultItem() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.hasPayloadLinkResultItem";
    }

    /**
     * <i>“Key of the Payload, In the format of Guid.”</i>
     * 
     * @return property payloadId
     */
    @Property(name="payloadId")
    @JsonIgnore
    public Optional<String> getPayloadId() {
        return Optional.ofNullable(payloadId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code payloadId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Key of the Payload, In the format of Guid.”</i>
     * 
     * @param payloadId
     *            new value of {@code payloadId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code payloadId} field changed
     */
    public HasPayloadLinkResultItem withPayloadId(String payloadId) {
        HasPayloadLinkResultItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hasPayloadLinkResultItem");
        _x.payloadId = payloadId;
        return _x;
    }

    /**
     * <i>“Indicate whether a payload has any link or not.”</i>
     * 
     * @return property hasLink
     */
    @Property(name="hasLink")
    @JsonIgnore
    public Optional<Boolean> getHasLink() {
        return Optional.ofNullable(hasLink);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code hasLink} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Indicate whether a payload has any link or not.”</i>
     * 
     * @param hasLink
     *            new value of {@code hasLink} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code hasLink} field changed
     */
    public HasPayloadLinkResultItem withHasLink(Boolean hasLink) {
        HasPayloadLinkResultItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hasPayloadLinkResultItem");
        _x.hasLink = hasLink;
        return _x;
    }

    /**
     * <i>“Exception information indicates if check for this item was successful or not.
     * Empty string for no error.”</i>
     * 
     * @return property error
     */
    @Property(name="error")
    @JsonIgnore
    public Optional<String> getError() {
        return Optional.ofNullable(error);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code error} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Exception information indicates if check for this item was successful or not.
     * Empty string for no error.”</i>
     * 
     * @param error
     *            new value of {@code error} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code error} field changed
     */
    public HasPayloadLinkResultItem withError(String error) {
        HasPayloadLinkResultItem _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hasPayloadLinkResultItem");
        _x.error = error;
        return _x;
    }

    /**
     * <i>“The reason where the link comes from.”</i>
     * 
     * @return property sources
     */
    @Property(name="sources")
    @JsonIgnore
    public CollectionPage<DeviceAndAppManagementAssignmentSource> getSources() {
        return new CollectionPage<DeviceAndAppManagementAssignmentSource>(contextPath, DeviceAndAppManagementAssignmentSource.class, sources, Optional.ofNullable(sourcesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“The reason where the link comes from.”</i>
     * 
     * @return property sources
     */
    @Property(name="sources")
    @JsonIgnore
    public CollectionPage<DeviceAndAppManagementAssignmentSource> getSources(HttpRequestOptions options) {
        return new CollectionPage<DeviceAndAppManagementAssignmentSource>(contextPath, DeviceAndAppManagementAssignmentSource.class, sources, Optional.ofNullable(sourcesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String payloadId;
        private Boolean hasLink;
        private String error;
        private List<DeviceAndAppManagementAssignmentSource> sources;
        private String sourcesNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Key of the Payload, In the format of Guid.”</i>
         * 
         * @param payloadId
         *            value of {@code payloadId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder payloadId(String payloadId) {
            this.payloadId = payloadId;
            this.changedFields = changedFields.add("payloadId");
            return this;
        }

        /**
         * <i>“Indicate whether a payload has any link or not.”</i>
         * 
         * @param hasLink
         *            value of {@code hasLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder hasLink(Boolean hasLink) {
            this.hasLink = hasLink;
            this.changedFields = changedFields.add("hasLink");
            return this;
        }

        /**
         * <i>“Exception information indicates if check for this item was successful or not.
         * Empty string for no error.”</i>
         * 
         * @param error
         *            value of {@code error} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder error(String error) {
            this.error = error;
            this.changedFields = changedFields.add("error");
            return this;
        }

        /**
         * <i>“The reason where the link comes from.”</i>
         * 
         * @param sources
         *            value of {@code sources} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder sources(List<DeviceAndAppManagementAssignmentSource> sources) {
            this.sources = sources;
            this.changedFields = changedFields.add("sources");
            return this;
        }

        /**
         * <i>“The reason where the link comes from.”</i>
         * 
         * @param sources
         *            value of {@code sources} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder sources(DeviceAndAppManagementAssignmentSource... sources) {
            return sources(Arrays.asList(sources));
        }

        /**
         * <i>“The reason where the link comes from.”</i>
         * 
         * @param sourcesNextLink
         *            value of {@code sources@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder sourcesNextLink(String sourcesNextLink) {
            this.sourcesNextLink = sourcesNextLink;
            this.changedFields = changedFields.add("sources");
            return this;
        }

        public HasPayloadLinkResultItem build() {
            HasPayloadLinkResultItem _x = new HasPayloadLinkResultItem();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.hasPayloadLinkResultItem";
            _x.payloadId = payloadId;
            _x.hasLink = hasLink;
            _x.error = error;
            _x.sources = sources;
            _x.sourcesNextLink = sourcesNextLink;
            return _x;
        }
    }

    private HasPayloadLinkResultItem _copy() {
        HasPayloadLinkResultItem _x = new HasPayloadLinkResultItem();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.payloadId = payloadId;
        _x.hasLink = hasLink;
        _x.error = error;
        _x.sources = sources;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("HasPayloadLinkResultItem[");
        b.append("payloadId=");
        b.append(this.payloadId);
        b.append(", ");
        b.append("hasLink=");
        b.append(this.hasLink);
        b.append(", ");
        b.append("error=");
        b.append(this.error);
        b.append(", ");
        b.append("sources=");
        b.append(this.sources);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
