package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.DeviceGuardLocalSystemAuthorityCredentialGuardState;
import odata.msgraph.client.beta.enums.DeviceGuardVirtualizationBasedSecurityHardwareRequirementState;
import odata.msgraph.client.beta.enums.DeviceGuardVirtualizationBasedSecurityState;
import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <i>“Hardware information of a given device.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "serialNumber", 
    "totalStorageSpace", 
    "freeStorageSpace", 
    "imei", 
    "meid", 
    "manufacturer", 
    "model", 
    "phoneNumber", 
    "subscriberCarrier", 
    "cellularTechnology", 
    "wifiMac", 
    "operatingSystemLanguage", 
    "isSupervised", 
    "isEncrypted", 
    "isSharedDevice", 
    "sharedDeviceCachedUsers", 
    "tpmSpecificationVersion", 
    "operatingSystemEdition", 
    "deviceFullQualifiedDomainName", 
    "deviceGuardVirtualizationBasedSecurityHardwareRequirementState", 
    "deviceGuardVirtualizationBasedSecurityState", 
    "deviceGuardLocalSystemAuthorityCredentialGuardState", 
    "osBuildNumber", 
    "operatingSystemProductType"})
@JsonInclude(Include.NON_NULL)
public class HardwareInformation implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("serialNumber")
    protected String serialNumber;

    @JsonProperty("totalStorageSpace")
    protected Long totalStorageSpace;

    @JsonProperty("freeStorageSpace")
    protected Long freeStorageSpace;

    @JsonProperty("imei")
    protected String imei;

    @JsonProperty("meid")
    protected String meid;

    @JsonProperty("manufacturer")
    protected String manufacturer;

    @JsonProperty("model")
    protected String model;

    @JsonProperty("phoneNumber")
    protected String phoneNumber;

    @JsonProperty("subscriberCarrier")
    protected String subscriberCarrier;

    @JsonProperty("cellularTechnology")
    protected String cellularTechnology;

    @JsonProperty("wifiMac")
    protected String wifiMac;

    @JsonProperty("operatingSystemLanguage")
    protected String operatingSystemLanguage;

    @JsonProperty("isSupervised")
    protected Boolean isSupervised;

    @JsonProperty("isEncrypted")
    protected Boolean isEncrypted;

    @JsonProperty("isSharedDevice")
    protected Boolean isSharedDevice;

    @JsonProperty("sharedDeviceCachedUsers")
    protected List<SharedAppleDeviceUser> sharedDeviceCachedUsers;

    @JsonProperty("sharedDeviceCachedUsers@nextLink")
    protected String sharedDeviceCachedUsersNextLink;

    @JsonProperty("tpmSpecificationVersion")
    protected String tpmSpecificationVersion;

    @JsonProperty("operatingSystemEdition")
    protected String operatingSystemEdition;

    @JsonProperty("deviceFullQualifiedDomainName")
    protected String deviceFullQualifiedDomainName;

    @JsonProperty("deviceGuardVirtualizationBasedSecurityHardwareRequirementState")
    protected DeviceGuardVirtualizationBasedSecurityHardwareRequirementState deviceGuardVirtualizationBasedSecurityHardwareRequirementState;

    @JsonProperty("deviceGuardVirtualizationBasedSecurityState")
    protected DeviceGuardVirtualizationBasedSecurityState deviceGuardVirtualizationBasedSecurityState;

    @JsonProperty("deviceGuardLocalSystemAuthorityCredentialGuardState")
    protected DeviceGuardLocalSystemAuthorityCredentialGuardState deviceGuardLocalSystemAuthorityCredentialGuardState;

    @JsonProperty("osBuildNumber")
    protected String osBuildNumber;

    @JsonProperty("operatingSystemProductType")
    protected Integer operatingSystemProductType;

    protected HardwareInformation() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.hardwareInformation";
    }

    /**
     * <i>“Serial number.”</i>
     * 
     * @return property serialNumber
     */
    @Property(name="serialNumber")
    @JsonIgnore
    public Optional<String> getSerialNumber() {
        return Optional.ofNullable(serialNumber);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code serialNumber}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Serial number.”</i>
     * 
     * @param serialNumber
     *            new value of {@code serialNumber} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code serialNumber} field changed
     */
    public HardwareInformation withSerialNumber(String serialNumber) {
        HardwareInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hardwareInformation");
        _x.serialNumber = serialNumber;
        return _x;
    }

    /**
     * <i>“Total storage space of the device.”</i>
     * 
     * @return property totalStorageSpace
     */
    @Property(name="totalStorageSpace")
    @JsonIgnore
    public Optional<Long> getTotalStorageSpace() {
        return Optional.ofNullable(totalStorageSpace);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code totalStorageSpace
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Total storage space of the device.”</i>
     * 
     * @param totalStorageSpace
     *            new value of {@code totalStorageSpace} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code totalStorageSpace} field changed
     */
    public HardwareInformation withTotalStorageSpace(Long totalStorageSpace) {
        HardwareInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hardwareInformation");
        _x.totalStorageSpace = totalStorageSpace;
        return _x;
    }

    /**
     * <i>“Free storage space of the device.”</i>
     * 
     * @return property freeStorageSpace
     */
    @Property(name="freeStorageSpace")
    @JsonIgnore
    public Optional<Long> getFreeStorageSpace() {
        return Optional.ofNullable(freeStorageSpace);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code freeStorageSpace}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Free storage space of the device.”</i>
     * 
     * @param freeStorageSpace
     *            new value of {@code freeStorageSpace} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code freeStorageSpace} field changed
     */
    public HardwareInformation withFreeStorageSpace(Long freeStorageSpace) {
        HardwareInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hardwareInformation");
        _x.freeStorageSpace = freeStorageSpace;
        return _x;
    }

    /**
     * <i>“IMEI”</i>
     * 
     * @return property imei
     */
    @Property(name="imei")
    @JsonIgnore
    public Optional<String> getImei() {
        return Optional.ofNullable(imei);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code imei} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“IMEI”</i>
     * 
     * @param imei
     *            new value of {@code imei} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code imei} field changed
     */
    public HardwareInformation withImei(String imei) {
        HardwareInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hardwareInformation");
        _x.imei = imei;
        return _x;
    }

    /**
     * <i>“MEID”</i>
     * 
     * @return property meid
     */
    @Property(name="meid")
    @JsonIgnore
    public Optional<String> getMeid() {
        return Optional.ofNullable(meid);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code meid} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“MEID”</i>
     * 
     * @param meid
     *            new value of {@code meid} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code meid} field changed
     */
    public HardwareInformation withMeid(String meid) {
        HardwareInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hardwareInformation");
        _x.meid = meid;
        return _x;
    }

    /**
     * <i>“Manufacturer of the device”</i>
     * 
     * @return property manufacturer
     */
    @Property(name="manufacturer")
    @JsonIgnore
    public Optional<String> getManufacturer() {
        return Optional.ofNullable(manufacturer);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code manufacturer}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Manufacturer of the device”</i>
     * 
     * @param manufacturer
     *            new value of {@code manufacturer} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code manufacturer} field changed
     */
    public HardwareInformation withManufacturer(String manufacturer) {
        HardwareInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hardwareInformation");
        _x.manufacturer = manufacturer;
        return _x;
    }

    /**
     * <i>“Model of the device”</i>
     * 
     * @return property model
     */
    @Property(name="model")
    @JsonIgnore
    public Optional<String> getModel() {
        return Optional.ofNullable(model);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code model} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Model of the device”</i>
     * 
     * @param model
     *            new value of {@code model} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code model} field changed
     */
    public HardwareInformation withModel(String model) {
        HardwareInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hardwareInformation");
        _x.model = model;
        return _x;
    }

    /**
     * <i>“Phone number of the device”</i>
     * 
     * @return property phoneNumber
     */
    @Property(name="phoneNumber")
    @JsonIgnore
    public Optional<String> getPhoneNumber() {
        return Optional.ofNullable(phoneNumber);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code phoneNumber}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Phone number of the device”</i>
     * 
     * @param phoneNumber
     *            new value of {@code phoneNumber} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code phoneNumber} field changed
     */
    public HardwareInformation withPhoneNumber(String phoneNumber) {
        HardwareInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hardwareInformation");
        _x.phoneNumber = phoneNumber;
        return _x;
    }

    /**
     * <i>“Subscriber carrier of the device”</i>
     * 
     * @return property subscriberCarrier
     */
    @Property(name="subscriberCarrier")
    @JsonIgnore
    public Optional<String> getSubscriberCarrier() {
        return Optional.ofNullable(subscriberCarrier);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code subscriberCarrier
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Subscriber carrier of the device”</i>
     * 
     * @param subscriberCarrier
     *            new value of {@code subscriberCarrier} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code subscriberCarrier} field changed
     */
    public HardwareInformation withSubscriberCarrier(String subscriberCarrier) {
        HardwareInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hardwareInformation");
        _x.subscriberCarrier = subscriberCarrier;
        return _x;
    }

    /**
     * <i>“Cellular technology of the device”</i>
     * 
     * @return property cellularTechnology
     */
    @Property(name="cellularTechnology")
    @JsonIgnore
    public Optional<String> getCellularTechnology() {
        return Optional.ofNullable(cellularTechnology);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * cellularTechnology} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Cellular technology of the device”</i>
     * 
     * @param cellularTechnology
     *            new value of {@code cellularTechnology} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code cellularTechnology} field changed
     */
    public HardwareInformation withCellularTechnology(String cellularTechnology) {
        HardwareInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hardwareInformation");
        _x.cellularTechnology = cellularTechnology;
        return _x;
    }

    /**
     * <i>“WiFi MAC address of the device”</i>
     * 
     * @return property wifiMac
     */
    @Property(name="wifiMac")
    @JsonIgnore
    public Optional<String> getWifiMac() {
        return Optional.ofNullable(wifiMac);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code wifiMac} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“WiFi MAC address of the device”</i>
     * 
     * @param wifiMac
     *            new value of {@code wifiMac} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code wifiMac} field changed
     */
    public HardwareInformation withWifiMac(String wifiMac) {
        HardwareInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hardwareInformation");
        _x.wifiMac = wifiMac;
        return _x;
    }

    /**
     * <i>“Operating system language of the device”</i>
     * 
     * @return property operatingSystemLanguage
     */
    @Property(name="operatingSystemLanguage")
    @JsonIgnore
    public Optional<String> getOperatingSystemLanguage() {
        return Optional.ofNullable(operatingSystemLanguage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * operatingSystemLanguage} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Operating system language of the device”</i>
     * 
     * @param operatingSystemLanguage
     *            new value of {@code operatingSystemLanguage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code operatingSystemLanguage} field changed
     */
    public HardwareInformation withOperatingSystemLanguage(String operatingSystemLanguage) {
        HardwareInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hardwareInformation");
        _x.operatingSystemLanguage = operatingSystemLanguage;
        return _x;
    }

    /**
     * <i>“Supervised mode of the device”</i>
     * 
     * @return property isSupervised
     */
    @Property(name="isSupervised")
    @JsonIgnore
    public Optional<Boolean> getIsSupervised() {
        return Optional.ofNullable(isSupervised);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code isSupervised}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Supervised mode of the device”</i>
     * 
     * @param isSupervised
     *            new value of {@code isSupervised} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code isSupervised} field changed
     */
    public HardwareInformation withIsSupervised(Boolean isSupervised) {
        HardwareInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hardwareInformation");
        _x.isSupervised = isSupervised;
        return _x;
    }

    /**
     * <i>“Encryption status of the device”</i>
     * 
     * @return property isEncrypted
     */
    @Property(name="isEncrypted")
    @JsonIgnore
    public Optional<Boolean> getIsEncrypted() {
        return Optional.ofNullable(isEncrypted);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code isEncrypted}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Encryption status of the device”</i>
     * 
     * @param isEncrypted
     *            new value of {@code isEncrypted} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code isEncrypted} field changed
     */
    public HardwareInformation withIsEncrypted(Boolean isEncrypted) {
        HardwareInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hardwareInformation");
        _x.isEncrypted = isEncrypted;
        return _x;
    }

    /**
     * <i>“Shared iPad”</i>
     * 
     * @return property isSharedDevice
     */
    @Property(name="isSharedDevice")
    @JsonIgnore
    public Optional<Boolean> getIsSharedDevice() {
        return Optional.ofNullable(isSharedDevice);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code isSharedDevice}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Shared iPad”</i>
     * 
     * @param isSharedDevice
     *            new value of {@code isSharedDevice} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code isSharedDevice} field changed
     */
    public HardwareInformation withIsSharedDevice(Boolean isSharedDevice) {
        HardwareInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hardwareInformation");
        _x.isSharedDevice = isSharedDevice;
        return _x;
    }

    /**
     * <i>“All users on the shared Apple device”</i>
     * 
     * @return property sharedDeviceCachedUsers
     */
    @Property(name="sharedDeviceCachedUsers")
    @JsonIgnore
    public CollectionPage<SharedAppleDeviceUser> getSharedDeviceCachedUsers() {
        return new CollectionPage<SharedAppleDeviceUser>(contextPath, SharedAppleDeviceUser.class, sharedDeviceCachedUsers, Optional.ofNullable(sharedDeviceCachedUsersNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“All users on the shared Apple device”</i>
     * 
     * @return property sharedDeviceCachedUsers
     */
    @Property(name="sharedDeviceCachedUsers")
    @JsonIgnore
    public CollectionPage<SharedAppleDeviceUser> getSharedDeviceCachedUsers(HttpRequestOptions options) {
        return new CollectionPage<SharedAppleDeviceUser>(contextPath, SharedAppleDeviceUser.class, sharedDeviceCachedUsers, Optional.ofNullable(sharedDeviceCachedUsersNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“String that specifies the specification version.”</i>
     * 
     * @return property tpmSpecificationVersion
     */
    @Property(name="tpmSpecificationVersion")
    @JsonIgnore
    public Optional<String> getTpmSpecificationVersion() {
        return Optional.ofNullable(tpmSpecificationVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * tpmSpecificationVersion} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“String that specifies the specification version.”</i>
     * 
     * @param tpmSpecificationVersion
     *            new value of {@code tpmSpecificationVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code tpmSpecificationVersion} field changed
     */
    public HardwareInformation withTpmSpecificationVersion(String tpmSpecificationVersion) {
        HardwareInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hardwareInformation");
        _x.tpmSpecificationVersion = tpmSpecificationVersion;
        return _x;
    }

    /**
     * <i>“String that specifies the OS edition.”</i>
     * 
     * @return property operatingSystemEdition
     */
    @Property(name="operatingSystemEdition")
    @JsonIgnore
    public Optional<String> getOperatingSystemEdition() {
        return Optional.ofNullable(operatingSystemEdition);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * operatingSystemEdition} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“String that specifies the OS edition.”</i>
     * 
     * @param operatingSystemEdition
     *            new value of {@code operatingSystemEdition} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code operatingSystemEdition} field changed
     */
    public HardwareInformation withOperatingSystemEdition(String operatingSystemEdition) {
        HardwareInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hardwareInformation");
        _x.operatingSystemEdition = operatingSystemEdition;
        return _x;
    }

    /**
     * <i>“Returns the fully qualified domain name of the device (if any). If the device is
     * not domain-joined, it returns an empty string.”</i>
     * 
     * @return property deviceFullQualifiedDomainName
     */
    @Property(name="deviceFullQualifiedDomainName")
    @JsonIgnore
    public Optional<String> getDeviceFullQualifiedDomainName() {
        return Optional.ofNullable(deviceFullQualifiedDomainName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceFullQualifiedDomainName} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Returns the fully qualified domain name of the device (if any). If the device is
     * not domain-joined, it returns an empty string.”</i>
     * 
     * @param deviceFullQualifiedDomainName
     *            new value of {@code deviceFullQualifiedDomainName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceFullQualifiedDomainName} field changed
     */
    public HardwareInformation withDeviceFullQualifiedDomainName(String deviceFullQualifiedDomainName) {
        HardwareInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hardwareInformation");
        _x.deviceFullQualifiedDomainName = deviceFullQualifiedDomainName;
        return _x;
    }

    /**
     * <i>“Virtualization-based security hardware requirement status.”</i>
     * 
     * @return property deviceGuardVirtualizationBasedSecurityHardwareRequirementState
     */
    @Property(name="deviceGuardVirtualizationBasedSecurityHardwareRequirementState")
    @JsonIgnore
    public Optional<DeviceGuardVirtualizationBasedSecurityHardwareRequirementState> getDeviceGuardVirtualizationBasedSecurityHardwareRequirementState() {
        return Optional.ofNullable(deviceGuardVirtualizationBasedSecurityHardwareRequirementState);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceGuardVirtualizationBasedSecurityHardwareRequirementState} field changed.
     * Field description below. The field name is also added to an internal map of
     * changed fields in the returned object so that when {@code this.patch()} is
     * called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Virtualization-based security hardware requirement status.”</i>
     * 
     * @param deviceGuardVirtualizationBasedSecurityHardwareRequirementState
     *            new value of {@code deviceGuardVirtualizationBasedSecurityHardwareRequirementState} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceGuardVirtualizationBasedSecurityHardwareRequirementState} field changed
     */
    public HardwareInformation withDeviceGuardVirtualizationBasedSecurityHardwareRequirementState(DeviceGuardVirtualizationBasedSecurityHardwareRequirementState deviceGuardVirtualizationBasedSecurityHardwareRequirementState) {
        HardwareInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hardwareInformation");
        _x.deviceGuardVirtualizationBasedSecurityHardwareRequirementState = deviceGuardVirtualizationBasedSecurityHardwareRequirementState;
        return _x;
    }

    /**
     * <i>“Virtualization-based security status.”</i>
     * 
     * @return property deviceGuardVirtualizationBasedSecurityState
     */
    @Property(name="deviceGuardVirtualizationBasedSecurityState")
    @JsonIgnore
    public Optional<DeviceGuardVirtualizationBasedSecurityState> getDeviceGuardVirtualizationBasedSecurityState() {
        return Optional.ofNullable(deviceGuardVirtualizationBasedSecurityState);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceGuardVirtualizationBasedSecurityState} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Virtualization-based security status.”</i>
     * 
     * @param deviceGuardVirtualizationBasedSecurityState
     *            new value of {@code deviceGuardVirtualizationBasedSecurityState} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceGuardVirtualizationBasedSecurityState} field changed
     */
    public HardwareInformation withDeviceGuardVirtualizationBasedSecurityState(DeviceGuardVirtualizationBasedSecurityState deviceGuardVirtualizationBasedSecurityState) {
        HardwareInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hardwareInformation");
        _x.deviceGuardVirtualizationBasedSecurityState = deviceGuardVirtualizationBasedSecurityState;
        return _x;
    }

    /**
     * <i>“Local System Authority (LSA) credential guard status.”</i>
     * 
     * @return property deviceGuardLocalSystemAuthorityCredentialGuardState
     */
    @Property(name="deviceGuardLocalSystemAuthorityCredentialGuardState")
    @JsonIgnore
    public Optional<DeviceGuardLocalSystemAuthorityCredentialGuardState> getDeviceGuardLocalSystemAuthorityCredentialGuardState() {
        return Optional.ofNullable(deviceGuardLocalSystemAuthorityCredentialGuardState);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceGuardLocalSystemAuthorityCredentialGuardState} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“Local System Authority (LSA) credential guard status.”</i>
     * 
     * @param deviceGuardLocalSystemAuthorityCredentialGuardState
     *            new value of {@code deviceGuardLocalSystemAuthorityCredentialGuardState} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceGuardLocalSystemAuthorityCredentialGuardState} field changed
     */
    public HardwareInformation withDeviceGuardLocalSystemAuthorityCredentialGuardState(DeviceGuardLocalSystemAuthorityCredentialGuardState deviceGuardLocalSystemAuthorityCredentialGuardState) {
        HardwareInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hardwareInformation");
        _x.deviceGuardLocalSystemAuthorityCredentialGuardState = deviceGuardLocalSystemAuthorityCredentialGuardState;
        return _x;
    }

    /**
     * <i>“Operating System Build Number on Android device”</i>
     * 
     * @return property osBuildNumber
     */
    @Property(name="osBuildNumber")
    @JsonIgnore
    public Optional<String> getOsBuildNumber() {
        return Optional.ofNullable(osBuildNumber);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code osBuildNumber}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Operating System Build Number on Android device”</i>
     * 
     * @param osBuildNumber
     *            new value of {@code osBuildNumber} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code osBuildNumber} field changed
     */
    public HardwareInformation withOsBuildNumber(String osBuildNumber) {
        HardwareInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hardwareInformation");
        _x.osBuildNumber = osBuildNumber;
        return _x;
    }

    /**
     * <i>“Int that specifies the Windows Operating System ProductType. More details here
     * https://go.microsoft.com/fwlink/?linkid=2126950. Valid values 0 to 2147483647”</i>
     * 
     * @return property operatingSystemProductType
     */
    @Property(name="operatingSystemProductType")
    @JsonIgnore
    public Optional<Integer> getOperatingSystemProductType() {
        return Optional.ofNullable(operatingSystemProductType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * operatingSystemProductType} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Int that specifies the Windows Operating System ProductType. More details here
     * https://go.microsoft.com/fwlink/?linkid=2126950. Valid values 0 to 2147483647”</i>
     * 
     * @param operatingSystemProductType
     *            new value of {@code operatingSystemProductType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code operatingSystemProductType} field changed
     */
    public HardwareInformation withOperatingSystemProductType(Integer operatingSystemProductType) {
        HardwareInformation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.hardwareInformation");
        _x.operatingSystemProductType = operatingSystemProductType;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String serialNumber;
        private Long totalStorageSpace;
        private Long freeStorageSpace;
        private String imei;
        private String meid;
        private String manufacturer;
        private String model;
        private String phoneNumber;
        private String subscriberCarrier;
        private String cellularTechnology;
        private String wifiMac;
        private String operatingSystemLanguage;
        private Boolean isSupervised;
        private Boolean isEncrypted;
        private Boolean isSharedDevice;
        private List<SharedAppleDeviceUser> sharedDeviceCachedUsers;
        private String sharedDeviceCachedUsersNextLink;
        private String tpmSpecificationVersion;
        private String operatingSystemEdition;
        private String deviceFullQualifiedDomainName;
        private DeviceGuardVirtualizationBasedSecurityHardwareRequirementState deviceGuardVirtualizationBasedSecurityHardwareRequirementState;
        private DeviceGuardVirtualizationBasedSecurityState deviceGuardVirtualizationBasedSecurityState;
        private DeviceGuardLocalSystemAuthorityCredentialGuardState deviceGuardLocalSystemAuthorityCredentialGuardState;
        private String osBuildNumber;
        private Integer operatingSystemProductType;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Serial number.”</i>
         * 
         * @param serialNumber
         *            value of {@code serialNumber} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            this.changedFields = changedFields.add("serialNumber");
            return this;
        }

        /**
         * <i>“Total storage space of the device.”</i>
         * 
         * @param totalStorageSpace
         *            value of {@code totalStorageSpace} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder totalStorageSpace(Long totalStorageSpace) {
            this.totalStorageSpace = totalStorageSpace;
            this.changedFields = changedFields.add("totalStorageSpace");
            return this;
        }

        /**
         * <i>“Free storage space of the device.”</i>
         * 
         * @param freeStorageSpace
         *            value of {@code freeStorageSpace} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder freeStorageSpace(Long freeStorageSpace) {
            this.freeStorageSpace = freeStorageSpace;
            this.changedFields = changedFields.add("freeStorageSpace");
            return this;
        }

        /**
         * <i>“IMEI”</i>
         * 
         * @param imei
         *            value of {@code imei} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder imei(String imei) {
            this.imei = imei;
            this.changedFields = changedFields.add("imei");
            return this;
        }

        /**
         * <i>“MEID”</i>
         * 
         * @param meid
         *            value of {@code meid} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder meid(String meid) {
            this.meid = meid;
            this.changedFields = changedFields.add("meid");
            return this;
        }

        /**
         * <i>“Manufacturer of the device”</i>
         * 
         * @param manufacturer
         *            value of {@code manufacturer} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder manufacturer(String manufacturer) {
            this.manufacturer = manufacturer;
            this.changedFields = changedFields.add("manufacturer");
            return this;
        }

        /**
         * <i>“Model of the device”</i>
         * 
         * @param model
         *            value of {@code model} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder model(String model) {
            this.model = model;
            this.changedFields = changedFields.add("model");
            return this;
        }

        /**
         * <i>“Phone number of the device”</i>
         * 
         * @param phoneNumber
         *            value of {@code phoneNumber} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            this.changedFields = changedFields.add("phoneNumber");
            return this;
        }

        /**
         * <i>“Subscriber carrier of the device”</i>
         * 
         * @param subscriberCarrier
         *            value of {@code subscriberCarrier} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder subscriberCarrier(String subscriberCarrier) {
            this.subscriberCarrier = subscriberCarrier;
            this.changedFields = changedFields.add("subscriberCarrier");
            return this;
        }

        /**
         * <i>“Cellular technology of the device”</i>
         * 
         * @param cellularTechnology
         *            value of {@code cellularTechnology} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder cellularTechnology(String cellularTechnology) {
            this.cellularTechnology = cellularTechnology;
            this.changedFields = changedFields.add("cellularTechnology");
            return this;
        }

        /**
         * <i>“WiFi MAC address of the device”</i>
         * 
         * @param wifiMac
         *            value of {@code wifiMac} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder wifiMac(String wifiMac) {
            this.wifiMac = wifiMac;
            this.changedFields = changedFields.add("wifiMac");
            return this;
        }

        /**
         * <i>“Operating system language of the device”</i>
         * 
         * @param operatingSystemLanguage
         *            value of {@code operatingSystemLanguage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder operatingSystemLanguage(String operatingSystemLanguage) {
            this.operatingSystemLanguage = operatingSystemLanguage;
            this.changedFields = changedFields.add("operatingSystemLanguage");
            return this;
        }

        /**
         * <i>“Supervised mode of the device”</i>
         * 
         * @param isSupervised
         *            value of {@code isSupervised} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder isSupervised(Boolean isSupervised) {
            this.isSupervised = isSupervised;
            this.changedFields = changedFields.add("isSupervised");
            return this;
        }

        /**
         * <i>“Encryption status of the device”</i>
         * 
         * @param isEncrypted
         *            value of {@code isEncrypted} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder isEncrypted(Boolean isEncrypted) {
            this.isEncrypted = isEncrypted;
            this.changedFields = changedFields.add("isEncrypted");
            return this;
        }

        /**
         * <i>“Shared iPad”</i>
         * 
         * @param isSharedDevice
         *            value of {@code isSharedDevice} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder isSharedDevice(Boolean isSharedDevice) {
            this.isSharedDevice = isSharedDevice;
            this.changedFields = changedFields.add("isSharedDevice");
            return this;
        }

        /**
         * <i>“All users on the shared Apple device”</i>
         * 
         * @param sharedDeviceCachedUsers
         *            value of {@code sharedDeviceCachedUsers} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder sharedDeviceCachedUsers(List<SharedAppleDeviceUser> sharedDeviceCachedUsers) {
            this.sharedDeviceCachedUsers = sharedDeviceCachedUsers;
            this.changedFields = changedFields.add("sharedDeviceCachedUsers");
            return this;
        }

        /**
         * <i>“All users on the shared Apple device”</i>
         * 
         * @param sharedDeviceCachedUsers
         *            value of {@code sharedDeviceCachedUsers} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder sharedDeviceCachedUsers(SharedAppleDeviceUser... sharedDeviceCachedUsers) {
            return sharedDeviceCachedUsers(Arrays.asList(sharedDeviceCachedUsers));
        }

        /**
         * <i>“All users on the shared Apple device”</i>
         * 
         * @param sharedDeviceCachedUsersNextLink
         *            value of {@code sharedDeviceCachedUsers@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder sharedDeviceCachedUsersNextLink(String sharedDeviceCachedUsersNextLink) {
            this.sharedDeviceCachedUsersNextLink = sharedDeviceCachedUsersNextLink;
            this.changedFields = changedFields.add("sharedDeviceCachedUsers");
            return this;
        }

        /**
         * <i>“String that specifies the specification version.”</i>
         * 
         * @param tpmSpecificationVersion
         *            value of {@code tpmSpecificationVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder tpmSpecificationVersion(String tpmSpecificationVersion) {
            this.tpmSpecificationVersion = tpmSpecificationVersion;
            this.changedFields = changedFields.add("tpmSpecificationVersion");
            return this;
        }

        /**
         * <i>“String that specifies the OS edition.”</i>
         * 
         * @param operatingSystemEdition
         *            value of {@code operatingSystemEdition} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder operatingSystemEdition(String operatingSystemEdition) {
            this.operatingSystemEdition = operatingSystemEdition;
            this.changedFields = changedFields.add("operatingSystemEdition");
            return this;
        }

        /**
         * <i>“Returns the fully qualified domain name of the device (if any). If the device is
         * not domain-joined, it returns an empty string.”</i>
         * 
         * @param deviceFullQualifiedDomainName
         *            value of {@code deviceFullQualifiedDomainName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceFullQualifiedDomainName(String deviceFullQualifiedDomainName) {
            this.deviceFullQualifiedDomainName = deviceFullQualifiedDomainName;
            this.changedFields = changedFields.add("deviceFullQualifiedDomainName");
            return this;
        }

        /**
         * <i>“Virtualization-based security hardware requirement status.”</i>
         * 
         * @param deviceGuardVirtualizationBasedSecurityHardwareRequirementState
         *            value of {@code deviceGuardVirtualizationBasedSecurityHardwareRequirementState} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceGuardVirtualizationBasedSecurityHardwareRequirementState(DeviceGuardVirtualizationBasedSecurityHardwareRequirementState deviceGuardVirtualizationBasedSecurityHardwareRequirementState) {
            this.deviceGuardVirtualizationBasedSecurityHardwareRequirementState = deviceGuardVirtualizationBasedSecurityHardwareRequirementState;
            this.changedFields = changedFields.add("deviceGuardVirtualizationBasedSecurityHardwareRequirementState");
            return this;
        }

        /**
         * <i>“Virtualization-based security status.”</i>
         * 
         * @param deviceGuardVirtualizationBasedSecurityState
         *            value of {@code deviceGuardVirtualizationBasedSecurityState} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceGuardVirtualizationBasedSecurityState(DeviceGuardVirtualizationBasedSecurityState deviceGuardVirtualizationBasedSecurityState) {
            this.deviceGuardVirtualizationBasedSecurityState = deviceGuardVirtualizationBasedSecurityState;
            this.changedFields = changedFields.add("deviceGuardVirtualizationBasedSecurityState");
            return this;
        }

        /**
         * <i>“Local System Authority (LSA) credential guard status.”</i>
         * 
         * @param deviceGuardLocalSystemAuthorityCredentialGuardState
         *            value of {@code deviceGuardLocalSystemAuthorityCredentialGuardState} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceGuardLocalSystemAuthorityCredentialGuardState(DeviceGuardLocalSystemAuthorityCredentialGuardState deviceGuardLocalSystemAuthorityCredentialGuardState) {
            this.deviceGuardLocalSystemAuthorityCredentialGuardState = deviceGuardLocalSystemAuthorityCredentialGuardState;
            this.changedFields = changedFields.add("deviceGuardLocalSystemAuthorityCredentialGuardState");
            return this;
        }

        /**
         * <i>“Operating System Build Number on Android device”</i>
         * 
         * @param osBuildNumber
         *            value of {@code osBuildNumber} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder osBuildNumber(String osBuildNumber) {
            this.osBuildNumber = osBuildNumber;
            this.changedFields = changedFields.add("osBuildNumber");
            return this;
        }

        /**
         * <i>“Int that specifies the Windows Operating System ProductType. More details here
         * https://go.microsoft.com/fwlink/?linkid=2126950. Valid values 0 to 2147483647”</i>
         * 
         * @param operatingSystemProductType
         *            value of {@code operatingSystemProductType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder operatingSystemProductType(Integer operatingSystemProductType) {
            this.operatingSystemProductType = operatingSystemProductType;
            this.changedFields = changedFields.add("operatingSystemProductType");
            return this;
        }

        public HardwareInformation build() {
            HardwareInformation _x = new HardwareInformation();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.hardwareInformation";
            _x.serialNumber = serialNumber;
            _x.totalStorageSpace = totalStorageSpace;
            _x.freeStorageSpace = freeStorageSpace;
            _x.imei = imei;
            _x.meid = meid;
            _x.manufacturer = manufacturer;
            _x.model = model;
            _x.phoneNumber = phoneNumber;
            _x.subscriberCarrier = subscriberCarrier;
            _x.cellularTechnology = cellularTechnology;
            _x.wifiMac = wifiMac;
            _x.operatingSystemLanguage = operatingSystemLanguage;
            _x.isSupervised = isSupervised;
            _x.isEncrypted = isEncrypted;
            _x.isSharedDevice = isSharedDevice;
            _x.sharedDeviceCachedUsers = sharedDeviceCachedUsers;
            _x.sharedDeviceCachedUsersNextLink = sharedDeviceCachedUsersNextLink;
            _x.tpmSpecificationVersion = tpmSpecificationVersion;
            _x.operatingSystemEdition = operatingSystemEdition;
            _x.deviceFullQualifiedDomainName = deviceFullQualifiedDomainName;
            _x.deviceGuardVirtualizationBasedSecurityHardwareRequirementState = deviceGuardVirtualizationBasedSecurityHardwareRequirementState;
            _x.deviceGuardVirtualizationBasedSecurityState = deviceGuardVirtualizationBasedSecurityState;
            _x.deviceGuardLocalSystemAuthorityCredentialGuardState = deviceGuardLocalSystemAuthorityCredentialGuardState;
            _x.osBuildNumber = osBuildNumber;
            _x.operatingSystemProductType = operatingSystemProductType;
            return _x;
        }
    }

    private HardwareInformation _copy() {
        HardwareInformation _x = new HardwareInformation();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.serialNumber = serialNumber;
        _x.totalStorageSpace = totalStorageSpace;
        _x.freeStorageSpace = freeStorageSpace;
        _x.imei = imei;
        _x.meid = meid;
        _x.manufacturer = manufacturer;
        _x.model = model;
        _x.phoneNumber = phoneNumber;
        _x.subscriberCarrier = subscriberCarrier;
        _x.cellularTechnology = cellularTechnology;
        _x.wifiMac = wifiMac;
        _x.operatingSystemLanguage = operatingSystemLanguage;
        _x.isSupervised = isSupervised;
        _x.isEncrypted = isEncrypted;
        _x.isSharedDevice = isSharedDevice;
        _x.sharedDeviceCachedUsers = sharedDeviceCachedUsers;
        _x.tpmSpecificationVersion = tpmSpecificationVersion;
        _x.operatingSystemEdition = operatingSystemEdition;
        _x.deviceFullQualifiedDomainName = deviceFullQualifiedDomainName;
        _x.deviceGuardVirtualizationBasedSecurityHardwareRequirementState = deviceGuardVirtualizationBasedSecurityHardwareRequirementState;
        _x.deviceGuardVirtualizationBasedSecurityState = deviceGuardVirtualizationBasedSecurityState;
        _x.deviceGuardLocalSystemAuthorityCredentialGuardState = deviceGuardLocalSystemAuthorityCredentialGuardState;
        _x.osBuildNumber = osBuildNumber;
        _x.operatingSystemProductType = operatingSystemProductType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("HardwareInformation[");
        b.append("serialNumber=");
        b.append(this.serialNumber);
        b.append(", ");
        b.append("totalStorageSpace=");
        b.append(this.totalStorageSpace);
        b.append(", ");
        b.append("freeStorageSpace=");
        b.append(this.freeStorageSpace);
        b.append(", ");
        b.append("imei=");
        b.append(this.imei);
        b.append(", ");
        b.append("meid=");
        b.append(this.meid);
        b.append(", ");
        b.append("manufacturer=");
        b.append(this.manufacturer);
        b.append(", ");
        b.append("model=");
        b.append(this.model);
        b.append(", ");
        b.append("phoneNumber=");
        b.append(this.phoneNumber);
        b.append(", ");
        b.append("subscriberCarrier=");
        b.append(this.subscriberCarrier);
        b.append(", ");
        b.append("cellularTechnology=");
        b.append(this.cellularTechnology);
        b.append(", ");
        b.append("wifiMac=");
        b.append(this.wifiMac);
        b.append(", ");
        b.append("operatingSystemLanguage=");
        b.append(this.operatingSystemLanguage);
        b.append(", ");
        b.append("isSupervised=");
        b.append(this.isSupervised);
        b.append(", ");
        b.append("isEncrypted=");
        b.append(this.isEncrypted);
        b.append(", ");
        b.append("isSharedDevice=");
        b.append(this.isSharedDevice);
        b.append(", ");
        b.append("sharedDeviceCachedUsers=");
        b.append(this.sharedDeviceCachedUsers);
        b.append(", ");
        b.append("tpmSpecificationVersion=");
        b.append(this.tpmSpecificationVersion);
        b.append(", ");
        b.append("operatingSystemEdition=");
        b.append(this.operatingSystemEdition);
        b.append(", ");
        b.append("deviceFullQualifiedDomainName=");
        b.append(this.deviceFullQualifiedDomainName);
        b.append(", ");
        b.append("deviceGuardVirtualizationBasedSecurityHardwareRequirementState=");
        b.append(this.deviceGuardVirtualizationBasedSecurityHardwareRequirementState);
        b.append(", ");
        b.append("deviceGuardVirtualizationBasedSecurityState=");
        b.append(this.deviceGuardVirtualizationBasedSecurityState);
        b.append(", ");
        b.append("deviceGuardLocalSystemAuthorityCredentialGuardState=");
        b.append(this.deviceGuardLocalSystemAuthorityCredentialGuardState);
        b.append(", ");
        b.append("osBuildNumber=");
        b.append(this.osBuildNumber);
        b.append(", ");
        b.append("operatingSystemProductType=");
        b.append(this.operatingSystemProductType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
