package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;


/**
 * <i>“The entity represents an ADML (Administrative Template language) XML file
 * uploaded by Administrator.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "fileName", 
    "languageCode", 
    "content", 
    "id", 
    "lastModifiedDateTime"})
@JsonInclude(Include.NON_NULL)
public class GroupPolicyUploadedLanguageFile implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("fileName")
    protected String fileName;

    @JsonProperty("languageCode")
    protected String languageCode;

    @JsonProperty("content")
    protected byte[] content;

    @JsonProperty("id")
    protected String id;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    protected GroupPolicyUploadedLanguageFile() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.groupPolicyUploadedLanguageFile";
    }

    /**
     * <i>“The file name of the uploaded ADML file.”</i>
     * 
     * @return property fileName
     */
    @Property(name="fileName")
    @JsonIgnore
    public Optional<String> getFileName() {
        return Optional.ofNullable(fileName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code fileName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The file name of the uploaded ADML file.”</i>
     * 
     * @param fileName
     *            new value of {@code fileName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code fileName} field changed
     */
    public GroupPolicyUploadedLanguageFile withFileName(String fileName) {
        GroupPolicyUploadedLanguageFile _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyUploadedLanguageFile");
        _x.fileName = fileName;
        return _x;
    }

    /**
     * <i>“The language code of the uploaded ADML file.”</i>
     * 
     * @return property languageCode
     */
    @Property(name="languageCode")
    @JsonIgnore
    public Optional<String> getLanguageCode() {
        return Optional.ofNullable(languageCode);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code languageCode}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The language code of the uploaded ADML file.”</i>
     * 
     * @param languageCode
     *            new value of {@code languageCode} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code languageCode} field changed
     */
    public GroupPolicyUploadedLanguageFile withLanguageCode(String languageCode) {
        GroupPolicyUploadedLanguageFile _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyUploadedLanguageFile");
        _x.languageCode = languageCode;
        return _x;
    }

    /**
     * <i>“The contents of the uploaded ADML file.”</i>
     * 
     * @return property content
     */
    @Property(name="content")
    @JsonIgnore
    public Optional<byte[]> getContent() {
        return Optional.ofNullable(content);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code content} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The contents of the uploaded ADML file.”</i>
     * 
     * @param content
     *            new value of {@code content} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code content} field changed
     */
    public GroupPolicyUploadedLanguageFile withContent(byte[] content) {
        GroupPolicyUploadedLanguageFile _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyUploadedLanguageFile");
        _x.content = content;
        return _x;
    }

    /**
     * <i>“Key of the entity.”</i>
     * 
     * @return property id
     */
    @Property(name="id")
    @JsonIgnore
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code id} field changed
     * . Field description below. The field name is also added to an internal map of
     * changed fields in the returned object so that when {@code this.patch()} is
     * called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Key of the entity.”</i>
     * 
     * @param id
     *            new value of {@code id} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code id} field changed
     */
    public GroupPolicyUploadedLanguageFile withId(String id) {
        GroupPolicyUploadedLanguageFile _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyUploadedLanguageFile");
        _x.id = id;
        return _x;
    }

    /**
     * <i>“The date and time the entity was last modified.”</i>
     * 
     * @return property lastModifiedDateTime
     */
    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastModifiedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The date and time the entity was last modified.”</i>
     * 
     * @param lastModifiedDateTime
     *            new value of {@code lastModifiedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastModifiedDateTime} field changed
     */
    public GroupPolicyUploadedLanguageFile withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        GroupPolicyUploadedLanguageFile _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupPolicyUploadedLanguageFile");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String fileName;
        private String languageCode;
        private byte[] content;
        private String id;
        private OffsetDateTime lastModifiedDateTime;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The file name of the uploaded ADML file.”</i>
         * 
         * @param fileName
         *            value of {@code fileName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder fileName(String fileName) {
            this.fileName = fileName;
            this.changedFields = changedFields.add("fileName");
            return this;
        }

        /**
         * <i>“The language code of the uploaded ADML file.”</i>
         * 
         * @param languageCode
         *            value of {@code languageCode} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            this.changedFields = changedFields.add("languageCode");
            return this;
        }

        /**
         * <i>“The contents of the uploaded ADML file.”</i>
         * 
         * @param content
         *            value of {@code content} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder content(byte[] content) {
            this.content = content;
            this.changedFields = changedFields.add("content");
            return this;
        }

        /**
         * <i>“Key of the entity.”</i>
         * 
         * @param id
         *            value of {@code id} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The date and time the entity was last modified.”</i>
         * 
         * @param lastModifiedDateTime
         *            value of {@code lastModifiedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public GroupPolicyUploadedLanguageFile build() {
            GroupPolicyUploadedLanguageFile _x = new GroupPolicyUploadedLanguageFile();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.groupPolicyUploadedLanguageFile";
            _x.fileName = fileName;
            _x.languageCode = languageCode;
            _x.content = content;
            _x.id = id;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            return _x;
        }
    }

    private GroupPolicyUploadedLanguageFile _copy() {
        GroupPolicyUploadedLanguageFile _x = new GroupPolicyUploadedLanguageFile();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.fileName = fileName;
        _x.languageCode = languageCode;
        _x.content = content;
        _x.id = id;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("GroupPolicyUploadedLanguageFile[");
        b.append("fileName=");
        b.append(this.fileName);
        b.append(", ");
        b.append("languageCode=");
        b.append(this.languageCode);
        b.append(", ");
        b.append("content=");
        b.append(this.content);
        b.append(", ");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
