package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "groupId"})
@JsonInclude(Include.NON_NULL)
public class GroupMembershipGovernanceCriteria extends GovernanceCriteria implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("groupId")
    protected String groupId;

    protected GroupMembershipGovernanceCriteria() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.groupMembershipGovernanceCriteria";
    }

    @Property(name="groupId")
    @JsonIgnore
    public Optional<String> getGroupId() {
        return Optional.ofNullable(groupId);
    }

    public GroupMembershipGovernanceCriteria withGroupId(String groupId) {
        GroupMembershipGovernanceCriteria _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupMembershipGovernanceCriteria");
        _x.groupId = groupId;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderGroupMembershipGovernanceCriteria() {
        return new Builder();
    }

    public static final class Builder {
        private String groupId;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder groupId(String groupId) {
            this.groupId = groupId;
            this.changedFields = changedFields.add("groupId");
            return this;
        }

        public GroupMembershipGovernanceCriteria build() {
            GroupMembershipGovernanceCriteria _x = new GroupMembershipGovernanceCriteria();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.groupMembershipGovernanceCriteria";
            _x.groupId = groupId;
            return _x;
        }
    }

    private GroupMembershipGovernanceCriteria _copy() {
        GroupMembershipGovernanceCriteria _x = new GroupMembershipGovernanceCriteria();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.groupId = groupId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("GroupMembershipGovernanceCriteria[");
        b.append("groupId=");
        b.append(this.groupId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
