package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.DeviceAndAppManagementAssignmentFilterType;


/**
 * <i>“Represents an assignment to a group.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "groupId"})
@JsonInclude(Include.NON_NULL)
public class GroupAssignmentTarget extends DeviceAndAppManagementAssignmentTarget implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("groupId")
    protected String groupId;

    protected GroupAssignmentTarget() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.groupAssignmentTarget";
    }

    /**
     * <i>“The group Id that is the target of the assignment.”</i>
     * 
     * @return property groupId
     */
    @Property(name="groupId")
    @JsonIgnore
    public Optional<String> getGroupId() {
        return Optional.ofNullable(groupId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code groupId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The group Id that is the target of the assignment.”</i>
     * 
     * @param groupId
     *            new value of {@code groupId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code groupId} field changed
     */
    public GroupAssignmentTarget withGroupId(String groupId) {
        GroupAssignmentTarget _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.groupAssignmentTarget");
        _x.groupId = groupId;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderGroupAssignmentTarget() {
        return new Builder();
    }

    public static final class Builder {
        private String deviceAndAppManagementAssignmentFilterId;
        private DeviceAndAppManagementAssignmentFilterType deviceAndAppManagementAssignmentFilterType;
        private String groupId;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder deviceAndAppManagementAssignmentFilterId(String deviceAndAppManagementAssignmentFilterId) {
            this.deviceAndAppManagementAssignmentFilterId = deviceAndAppManagementAssignmentFilterId;
            this.changedFields = changedFields.add("deviceAndAppManagementAssignmentFilterId");
            return this;
        }

        public Builder deviceAndAppManagementAssignmentFilterType(DeviceAndAppManagementAssignmentFilterType deviceAndAppManagementAssignmentFilterType) {
            this.deviceAndAppManagementAssignmentFilterType = deviceAndAppManagementAssignmentFilterType;
            this.changedFields = changedFields.add("deviceAndAppManagementAssignmentFilterType");
            return this;
        }

        /**
         * <i>“The group Id that is the target of the assignment.”</i>
         * 
         * @param groupId
         *            value of {@code groupId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder groupId(String groupId) {
            this.groupId = groupId;
            this.changedFields = changedFields.add("groupId");
            return this;
        }

        public GroupAssignmentTarget build() {
            GroupAssignmentTarget _x = new GroupAssignmentTarget();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.groupAssignmentTarget";
            _x.deviceAndAppManagementAssignmentFilterId = deviceAndAppManagementAssignmentFilterId;
            _x.deviceAndAppManagementAssignmentFilterType = deviceAndAppManagementAssignmentFilterType;
            _x.groupId = groupId;
            return _x;
        }
    }

    private GroupAssignmentTarget _copy() {
        GroupAssignmentTarget _x = new GroupAssignmentTarget();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.deviceAndAppManagementAssignmentFilterId = deviceAndAppManagementAssignmentFilterId;
        _x.deviceAndAppManagementAssignmentFilterType = deviceAndAppManagementAssignmentFilterType;
        _x.groupId = groupId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("GroupAssignmentTarget[");
        b.append("deviceAndAppManagementAssignmentFilterId=");
        b.append(this.deviceAndAppManagementAssignmentFilterId);
        b.append(", ");
        b.append("deviceAndAppManagementAssignmentFilterType=");
        b.append(this.deviceAndAppManagementAssignmentFilterType);
        b.append(", ");
        b.append("groupId=");
        b.append(this.groupId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
