package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "accessLevel", 
    "isActive", 
    "isEligible"})
@JsonInclude(Include.NON_NULL)
public class GovernancePermission implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("accessLevel")
    protected String accessLevel;

    @JsonProperty("isActive")
    protected Boolean isActive;

    @JsonProperty("isEligible")
    protected Boolean isEligible;

    protected GovernancePermission() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.governancePermission";
    }

    @Property(name="accessLevel")
    @JsonIgnore
    public Optional<String> getAccessLevel() {
        return Optional.ofNullable(accessLevel);
    }

    public GovernancePermission withAccessLevel(String accessLevel) {
        GovernancePermission _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governancePermission");
        _x.accessLevel = accessLevel;
        return _x;
    }

    @Property(name="isActive")
    @JsonIgnore
    public Optional<Boolean> getIsActive() {
        return Optional.ofNullable(isActive);
    }

    public GovernancePermission withIsActive(Boolean isActive) {
        GovernancePermission _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governancePermission");
        _x.isActive = isActive;
        return _x;
    }

    @Property(name="isEligible")
    @JsonIgnore
    public Optional<Boolean> getIsEligible() {
        return Optional.ofNullable(isEligible);
    }

    public GovernancePermission withIsEligible(Boolean isEligible) {
        GovernancePermission _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governancePermission");
        _x.isEligible = isEligible;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String accessLevel;
        private Boolean isActive;
        private Boolean isEligible;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder accessLevel(String accessLevel) {
            this.accessLevel = accessLevel;
            this.changedFields = changedFields.add("accessLevel");
            return this;
        }

        public Builder isActive(Boolean isActive) {
            this.isActive = isActive;
            this.changedFields = changedFields.add("isActive");
            return this;
        }

        public Builder isEligible(Boolean isEligible) {
            this.isEligible = isEligible;
            this.changedFields = changedFields.add("isEligible");
            return this;
        }

        public GovernancePermission build() {
            GovernancePermission _x = new GovernancePermission();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.governancePermission";
            _x.accessLevel = accessLevel;
            _x.isActive = isActive;
            _x.isEligible = isEligible;
            return _x;
        }
    }

    private GovernancePermission _copy() {
        GovernancePermission _x = new GovernancePermission();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.accessLevel = accessLevel;
        _x.isActive = isActive;
        _x.isEligible = isEligible;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("GovernancePermission[");
        b.append("accessLevel=");
        b.append(this.accessLevel);
        b.append(", ");
        b.append("isActive=");
        b.append(this.isActive);
        b.append(", ");
        b.append("isEligible=");
        b.append(this.isEligible);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
