package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "id", 
    "type", 
    "source", 
    "version", 
    "culture"})
@JsonInclude(Include.NON_NULL)
public class GovernanceNotificationTemplate implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("id")
    protected String id;

    @JsonProperty("type")
    protected String type;

    @JsonProperty("source")
    protected String source;

    @JsonProperty("version")
    protected String version;

    @JsonProperty("culture")
    protected String culture;

    protected GovernanceNotificationTemplate() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.governanceNotificationTemplate";
    }

    @Property(name="id")
    @JsonIgnore
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    public GovernanceNotificationTemplate withId(String id) {
        GovernanceNotificationTemplate _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceNotificationTemplate");
        _x.id = id;
        return _x;
    }

    @Property(name="type")
    @JsonIgnore
    public Optional<String> getType() {
        return Optional.ofNullable(type);
    }

    public GovernanceNotificationTemplate withType(String type) {
        GovernanceNotificationTemplate _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceNotificationTemplate");
        _x.type = type;
        return _x;
    }

    @Property(name="source")
    @JsonIgnore
    public Optional<String> getSource() {
        return Optional.ofNullable(source);
    }

    public GovernanceNotificationTemplate withSource(String source) {
        GovernanceNotificationTemplate _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceNotificationTemplate");
        _x.source = source;
        return _x;
    }

    @Property(name="version")
    @JsonIgnore
    public Optional<String> getVersion() {
        return Optional.ofNullable(version);
    }

    public GovernanceNotificationTemplate withVersion(String version) {
        GovernanceNotificationTemplate _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceNotificationTemplate");
        _x.version = version;
        return _x;
    }

    @Property(name="culture")
    @JsonIgnore
    public Optional<String> getCulture() {
        return Optional.ofNullable(culture);
    }

    public GovernanceNotificationTemplate withCulture(String culture) {
        GovernanceNotificationTemplate _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.governanceNotificationTemplate");
        _x.culture = culture;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String type;
        private String source;
        private String version;
        private String culture;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public Builder source(String source) {
            this.source = source;
            this.changedFields = changedFields.add("source");
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder culture(String culture) {
            this.culture = culture;
            this.changedFields = changedFields.add("culture");
            return this;
        }

        public GovernanceNotificationTemplate build() {
            GovernanceNotificationTemplate _x = new GovernanceNotificationTemplate();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.governanceNotificationTemplate";
            _x.id = id;
            _x.type = type;
            _x.source = source;
            _x.version = version;
            _x.culture = culture;
            return _x;
        }
    }

    private GovernanceNotificationTemplate _copy() {
        GovernanceNotificationTemplate _x = new GovernanceNotificationTemplate();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.type = type;
        _x.source = source;
        _x.version = version;
        _x.culture = culture;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("GovernanceNotificationTemplate[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("type=");
        b.append(this.type);
        b.append(", ");
        b.append("source=");
        b.append(this.source);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("culture=");
        b.append(this.culture);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
