package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "notificationTemplates", 
    "enabledTemplateTypes"})
@JsonInclude(Include.NON_NULL)
public class GovernanceNotificationPolicy implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("notificationTemplates")
    protected List<GovernanceNotificationTemplate> notificationTemplates;

    @JsonProperty("notificationTemplates@nextLink")
    protected String notificationTemplatesNextLink;

    @JsonProperty("enabledTemplateTypes")
    protected List<String> enabledTemplateTypes;

    @JsonProperty("enabledTemplateTypes@nextLink")
    protected String enabledTemplateTypesNextLink;

    protected GovernanceNotificationPolicy() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.governanceNotificationPolicy";
    }

    @Property(name="notificationTemplates")
    @JsonIgnore
    public CollectionPage<GovernanceNotificationTemplate> getNotificationTemplates() {
        return new CollectionPage<GovernanceNotificationTemplate>(contextPath, GovernanceNotificationTemplate.class, notificationTemplates, Optional.ofNullable(notificationTemplatesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="notificationTemplates")
    @JsonIgnore
    public CollectionPage<GovernanceNotificationTemplate> getNotificationTemplates(HttpRequestOptions options) {
        return new CollectionPage<GovernanceNotificationTemplate>(contextPath, GovernanceNotificationTemplate.class, notificationTemplates, Optional.ofNullable(notificationTemplatesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="enabledTemplateTypes")
    @JsonIgnore
    public CollectionPage<String> getEnabledTemplateTypes() {
        return new CollectionPage<String>(contextPath, String.class, enabledTemplateTypes, Optional.ofNullable(enabledTemplateTypesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="enabledTemplateTypes")
    @JsonIgnore
    public CollectionPage<String> getEnabledTemplateTypes(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, enabledTemplateTypes, Optional.ofNullable(enabledTemplateTypesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<GovernanceNotificationTemplate> notificationTemplates;
        private String notificationTemplatesNextLink;
        private List<String> enabledTemplateTypes;
        private String enabledTemplateTypesNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder notificationTemplates(List<GovernanceNotificationTemplate> notificationTemplates) {
            this.notificationTemplates = notificationTemplates;
            this.changedFields = changedFields.add("notificationTemplates");
            return this;
        }

        public Builder notificationTemplates(GovernanceNotificationTemplate... notificationTemplates) {
            return notificationTemplates(Arrays.asList(notificationTemplates));
        }

        public Builder notificationTemplatesNextLink(String notificationTemplatesNextLink) {
            this.notificationTemplatesNextLink = notificationTemplatesNextLink;
            this.changedFields = changedFields.add("notificationTemplates");
            return this;
        }

        public Builder enabledTemplateTypes(List<String> enabledTemplateTypes) {
            this.enabledTemplateTypes = enabledTemplateTypes;
            this.changedFields = changedFields.add("enabledTemplateTypes");
            return this;
        }

        public Builder enabledTemplateTypes(String... enabledTemplateTypes) {
            return enabledTemplateTypes(Arrays.asList(enabledTemplateTypes));
        }

        public Builder enabledTemplateTypesNextLink(String enabledTemplateTypesNextLink) {
            this.enabledTemplateTypesNextLink = enabledTemplateTypesNextLink;
            this.changedFields = changedFields.add("enabledTemplateTypes");
            return this;
        }

        public GovernanceNotificationPolicy build() {
            GovernanceNotificationPolicy _x = new GovernanceNotificationPolicy();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.governanceNotificationPolicy";
            _x.notificationTemplates = notificationTemplates;
            _x.notificationTemplatesNextLink = notificationTemplatesNextLink;
            _x.enabledTemplateTypes = enabledTemplateTypes;
            _x.enabledTemplateTypesNextLink = enabledTemplateTypesNextLink;
            return _x;
        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("GovernanceNotificationPolicy[");
        b.append("notificationTemplates=");
        b.append(this.notificationTemplates);
        b.append(", ");
        b.append("enabledTemplateTypes=");
        b.append(this.enabledTemplateTypes);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
