package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "clauses", 
    "name"})
@JsonInclude(Include.NON_NULL)
public class FilterGroup implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("clauses")
    protected List<FilterClause> clauses;

    @JsonProperty("clauses@nextLink")
    protected String clausesNextLink;

    @JsonProperty("name")
    protected String name;

    protected FilterGroup() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.filterGroup";
    }

    @Property(name="clauses")
    @JsonIgnore
    public CollectionPage<FilterClause> getClauses() {
        return new CollectionPage<FilterClause>(contextPath, FilterClause.class, clauses, Optional.ofNullable(clausesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="clauses")
    @JsonIgnore
    public CollectionPage<FilterClause> getClauses(HttpRequestOptions options) {
        return new CollectionPage<FilterClause>(contextPath, FilterClause.class, clauses, Optional.ofNullable(clausesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public FilterGroup withName(String name) {
        FilterGroup _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.filterGroup");
        _x.name = name;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<FilterClause> clauses;
        private String clausesNextLink;
        private String name;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder clauses(List<FilterClause> clauses) {
            this.clauses = clauses;
            this.changedFields = changedFields.add("clauses");
            return this;
        }

        public Builder clauses(FilterClause... clauses) {
            return clauses(Arrays.asList(clauses));
        }

        public Builder clausesNextLink(String clausesNextLink) {
            this.clausesNextLink = clausesNextLink;
            this.changedFields = changedFields.add("clauses");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public FilterGroup build() {
            FilterGroup _x = new FilterGroup();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.filterGroup";
            _x.clauses = clauses;
            _x.clausesNextLink = clausesNextLink;
            _x.name = name;
            return _x;
        }
    }

    private FilterGroup _copy() {
        FilterGroup _x = new FilterGroup();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.clauses = clauses;
        _x.name = name;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("FilterGroup[");
        b.append("clauses=");
        b.append(this.clauses);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
