package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "createdDateTime", 
    "lastAccessedDateTime", 
    "lastModifiedDateTime"})
@JsonInclude(Include.NON_NULL)
public class FileSystemInfo implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("lastAccessedDateTime")
    protected OffsetDateTime lastAccessedDateTime;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    protected FileSystemInfo() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.fileSystemInfo";
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public FileSystemInfo withCreatedDateTime(OffsetDateTime createdDateTime) {
        FileSystemInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.fileSystemInfo");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="lastAccessedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastAccessedDateTime() {
        return Optional.ofNullable(lastAccessedDateTime);
    }

    public FileSystemInfo withLastAccessedDateTime(OffsetDateTime lastAccessedDateTime) {
        FileSystemInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.fileSystemInfo");
        _x.lastAccessedDateTime = lastAccessedDateTime;
        return _x;
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public FileSystemInfo withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        FileSystemInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.fileSystemInfo");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime createdDateTime;
        private OffsetDateTime lastAccessedDateTime;
        private OffsetDateTime lastModifiedDateTime;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder lastAccessedDateTime(OffsetDateTime lastAccessedDateTime) {
            this.lastAccessedDateTime = lastAccessedDateTime;
            this.changedFields = changedFields.add("lastAccessedDateTime");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public FileSystemInfo build() {
            FileSystemInfo _x = new FileSystemInfo();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.fileSystemInfo";
            _x.createdDateTime = createdDateTime;
            _x.lastAccessedDateTime = lastAccessedDateTime;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            return _x;
        }
    }

    private FileSystemInfo _copy() {
        FileSystemInfo _x = new FileSystemInfo();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.createdDateTime = createdDateTime;
        _x.lastAccessedDateTime = lastAccessedDateTime;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("FileSystemInfo[");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("lastAccessedDateTime=");
        b.append(this.lastAccessedDateTime);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
