package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "fileHash", 
    "name", 
    "path", 
    "riskScore"})
@JsonInclude(Include.NON_NULL)
public class FileSecurityState implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("fileHash")
    protected FileHash fileHash;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("path")
    protected String path;

    @JsonProperty("riskScore")
    protected String riskScore;

    protected FileSecurityState() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.fileSecurityState";
    }

    @Property(name="fileHash")
    @JsonIgnore
    public Optional<FileHash> getFileHash() {
        return Optional.ofNullable(fileHash);
    }

    public FileSecurityState withFileHash(FileHash fileHash) {
        FileSecurityState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.fileSecurityState");
        _x.fileHash = fileHash;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public FileSecurityState withName(String name) {
        FileSecurityState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.fileSecurityState");
        _x.name = name;
        return _x;
    }

    @Property(name="path")
    @JsonIgnore
    public Optional<String> getPath() {
        return Optional.ofNullable(path);
    }

    public FileSecurityState withPath(String path) {
        FileSecurityState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.fileSecurityState");
        _x.path = path;
        return _x;
    }

    @Property(name="riskScore")
    @JsonIgnore
    public Optional<String> getRiskScore() {
        return Optional.ofNullable(riskScore);
    }

    public FileSecurityState withRiskScore(String riskScore) {
        FileSecurityState _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.fileSecurityState");
        _x.riskScore = riskScore;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private FileHash fileHash;
        private String name;
        private String path;
        private String riskScore;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder fileHash(FileHash fileHash) {
            this.fileHash = fileHash;
            this.changedFields = changedFields.add("fileHash");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            this.changedFields = changedFields.add("path");
            return this;
        }

        public Builder riskScore(String riskScore) {
            this.riskScore = riskScore;
            this.changedFields = changedFields.add("riskScore");
            return this;
        }

        public FileSecurityState build() {
            FileSecurityState _x = new FileSecurityState();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.fileSecurityState";
            _x.fileHash = fileHash;
            _x.name = name;
            _x.path = path;
            _x.riskScore = riskScore;
            return _x;
        }
    }

    private FileSecurityState _copy() {
        FileSecurityState _x = new FileSecurityState();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.fileHash = fileHash;
        _x.name = name;
        _x.path = path;
        _x.riskScore = riskScore;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("FileSecurityState[");
        b.append("fileHash=");
        b.append(this.fileHash);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("path=");
        b.append(this.path);
        b.append(", ");
        b.append("riskScore=");
        b.append(this.riskScore);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
