package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.FileHashType;

@JsonPropertyOrder({
    "@odata.type", 
    "hashType", 
    "hashValue"})
@JsonInclude(Include.NON_NULL)
public class FileHash implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("hashType")
    protected FileHashType hashType;

    @JsonProperty("hashValue")
    protected String hashValue;

    protected FileHash() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.fileHash";
    }

    @Property(name="hashType")
    @JsonIgnore
    public Optional<FileHashType> getHashType() {
        return Optional.ofNullable(hashType);
    }

    public FileHash withHashType(FileHashType hashType) {
        FileHash _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.fileHash");
        _x.hashType = hashType;
        return _x;
    }

    @Property(name="hashValue")
    @JsonIgnore
    public Optional<String> getHashValue() {
        return Optional.ofNullable(hashValue);
    }

    public FileHash withHashValue(String hashValue) {
        FileHash _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.fileHash");
        _x.hashValue = hashValue;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private FileHashType hashType;
        private String hashValue;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder hashType(FileHashType hashType) {
            this.hashType = hashType;
            this.changedFields = changedFields.add("hashType");
            return this;
        }

        public Builder hashValue(String hashValue) {
            this.hashValue = hashValue;
            this.changedFields = changedFields.add("hashValue");
            return this;
        }

        public FileHash build() {
            FileHash _x = new FileHash();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.fileHash";
            _x.hashType = hashType;
            _x.hashValue = hashValue;
            return _x;
        }
    }

    private FileHash _copy() {
        FileHash _x = new FileHash();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.hashType = hashType;
        _x.hashValue = hashValue;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("FileHash[");
        b.append("hashType=");
        b.append(this.hashType);
        b.append(", ");
        b.append("hashValue=");
        b.append(this.hashValue);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
