package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.Fido2RestrictionEnforcementType;

@JsonPropertyOrder({
    "@odata.type", 
    "isEnforced", 
    "enforcementType", 
    "aaGuids"})
@JsonInclude(Include.NON_NULL)
public class Fido2KeyRestrictions implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("isEnforced")
    protected Boolean isEnforced;

    @JsonProperty("enforcementType")
    protected Fido2RestrictionEnforcementType enforcementType;

    @JsonProperty("aaGuids")
    protected List<String> aaGuids;

    @JsonProperty("aaGuids@nextLink")
    protected String aaGuidsNextLink;

    protected Fido2KeyRestrictions() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.fido2KeyRestrictions";
    }

    @Property(name="isEnforced")
    @JsonIgnore
    public Optional<Boolean> getIsEnforced() {
        return Optional.ofNullable(isEnforced);
    }

    public Fido2KeyRestrictions withIsEnforced(Boolean isEnforced) {
        Fido2KeyRestrictions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.fido2KeyRestrictions");
        _x.isEnforced = isEnforced;
        return _x;
    }

    @Property(name="enforcementType")
    @JsonIgnore
    public Optional<Fido2RestrictionEnforcementType> getEnforcementType() {
        return Optional.ofNullable(enforcementType);
    }

    public Fido2KeyRestrictions withEnforcementType(Fido2RestrictionEnforcementType enforcementType) {
        Fido2KeyRestrictions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.fido2KeyRestrictions");
        _x.enforcementType = enforcementType;
        return _x;
    }

    @Property(name="aaGuids")
    @JsonIgnore
    public CollectionPage<String> getAaGuids() {
        return new CollectionPage<String>(contextPath, String.class, aaGuids, Optional.ofNullable(aaGuidsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="aaGuids")
    @JsonIgnore
    public CollectionPage<String> getAaGuids(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, aaGuids, Optional.ofNullable(aaGuidsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean isEnforced;
        private Fido2RestrictionEnforcementType enforcementType;
        private List<String> aaGuids;
        private String aaGuidsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder isEnforced(Boolean isEnforced) {
            this.isEnforced = isEnforced;
            this.changedFields = changedFields.add("isEnforced");
            return this;
        }

        public Builder enforcementType(Fido2RestrictionEnforcementType enforcementType) {
            this.enforcementType = enforcementType;
            this.changedFields = changedFields.add("enforcementType");
            return this;
        }

        public Builder aaGuids(List<String> aaGuids) {
            this.aaGuids = aaGuids;
            this.changedFields = changedFields.add("aaGuids");
            return this;
        }

        public Builder aaGuids(String... aaGuids) {
            return aaGuids(Arrays.asList(aaGuids));
        }

        public Builder aaGuidsNextLink(String aaGuidsNextLink) {
            this.aaGuidsNextLink = aaGuidsNextLink;
            this.changedFields = changedFields.add("aaGuids");
            return this;
        }

        public Fido2KeyRestrictions build() {
            Fido2KeyRestrictions _x = new Fido2KeyRestrictions();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.fido2KeyRestrictions";
            _x.isEnforced = isEnforced;
            _x.enforcementType = enforcementType;
            _x.aaGuids = aaGuids;
            _x.aaGuidsNextLink = aaGuidsNextLink;
            return _x;
        }
    }

    private Fido2KeyRestrictions _copy() {
        Fido2KeyRestrictions _x = new Fido2KeyRestrictions();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.isEnforced = isEnforced;
        _x.enforcementType = enforcementType;
        _x.aaGuids = aaGuids;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Fido2KeyRestrictions[");
        b.append("isEnforced=");
        b.append(this.isEnforced);
        b.append(", ");
        b.append("enforcementType=");
        b.append(this.enforcementType);
        b.append(", ");
        b.append("aaGuids=");
        b.append(this.aaGuids);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
