package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.AzureADLicenseType;

@JsonPropertyOrder({
    "@odata.type", 
    "featureName", 
    "licenseRequired", 
    "licenseAssigned", 
    "lastUsedDateTime", 
    "lastConfiguredDateTime"})
@JsonInclude(Include.NON_NULL)
public class FeatureUsageDetail implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("featureName")
    protected String featureName;

    @JsonProperty("licenseRequired")
    protected AzureADLicenseType licenseRequired;

    @JsonProperty("licenseAssigned")
    protected AzureADLicenseType licenseAssigned;

    @JsonProperty("lastUsedDateTime")
    protected OffsetDateTime lastUsedDateTime;

    @JsonProperty("lastConfiguredDateTime")
    protected OffsetDateTime lastConfiguredDateTime;

    protected FeatureUsageDetail() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.featureUsageDetail";
    }

    @Property(name="featureName")
    @JsonIgnore
    public Optional<String> getFeatureName() {
        return Optional.ofNullable(featureName);
    }

    public FeatureUsageDetail withFeatureName(String featureName) {
        FeatureUsageDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.featureUsageDetail");
        _x.featureName = featureName;
        return _x;
    }

    @Property(name="licenseRequired")
    @JsonIgnore
    public Optional<AzureADLicenseType> getLicenseRequired() {
        return Optional.ofNullable(licenseRequired);
    }

    public FeatureUsageDetail withLicenseRequired(AzureADLicenseType licenseRequired) {
        FeatureUsageDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.featureUsageDetail");
        _x.licenseRequired = licenseRequired;
        return _x;
    }

    @Property(name="licenseAssigned")
    @JsonIgnore
    public Optional<AzureADLicenseType> getLicenseAssigned() {
        return Optional.ofNullable(licenseAssigned);
    }

    public FeatureUsageDetail withLicenseAssigned(AzureADLicenseType licenseAssigned) {
        FeatureUsageDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.featureUsageDetail");
        _x.licenseAssigned = licenseAssigned;
        return _x;
    }

    @Property(name="lastUsedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastUsedDateTime() {
        return Optional.ofNullable(lastUsedDateTime);
    }

    public FeatureUsageDetail withLastUsedDateTime(OffsetDateTime lastUsedDateTime) {
        FeatureUsageDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.featureUsageDetail");
        _x.lastUsedDateTime = lastUsedDateTime;
        return _x;
    }

    @Property(name="lastConfiguredDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastConfiguredDateTime() {
        return Optional.ofNullable(lastConfiguredDateTime);
    }

    public FeatureUsageDetail withLastConfiguredDateTime(OffsetDateTime lastConfiguredDateTime) {
        FeatureUsageDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.featureUsageDetail");
        _x.lastConfiguredDateTime = lastConfiguredDateTime;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String featureName;
        private AzureADLicenseType licenseRequired;
        private AzureADLicenseType licenseAssigned;
        private OffsetDateTime lastUsedDateTime;
        private OffsetDateTime lastConfiguredDateTime;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder featureName(String featureName) {
            this.featureName = featureName;
            this.changedFields = changedFields.add("featureName");
            return this;
        }

        public Builder licenseRequired(AzureADLicenseType licenseRequired) {
            this.licenseRequired = licenseRequired;
            this.changedFields = changedFields.add("licenseRequired");
            return this;
        }

        public Builder licenseAssigned(AzureADLicenseType licenseAssigned) {
            this.licenseAssigned = licenseAssigned;
            this.changedFields = changedFields.add("licenseAssigned");
            return this;
        }

        public Builder lastUsedDateTime(OffsetDateTime lastUsedDateTime) {
            this.lastUsedDateTime = lastUsedDateTime;
            this.changedFields = changedFields.add("lastUsedDateTime");
            return this;
        }

        public Builder lastConfiguredDateTime(OffsetDateTime lastConfiguredDateTime) {
            this.lastConfiguredDateTime = lastConfiguredDateTime;
            this.changedFields = changedFields.add("lastConfiguredDateTime");
            return this;
        }

        public FeatureUsageDetail build() {
            FeatureUsageDetail _x = new FeatureUsageDetail();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.featureUsageDetail";
            _x.featureName = featureName;
            _x.licenseRequired = licenseRequired;
            _x.licenseAssigned = licenseAssigned;
            _x.lastUsedDateTime = lastUsedDateTime;
            _x.lastConfiguredDateTime = lastConfiguredDateTime;
            return _x;
        }
    }

    private FeatureUsageDetail _copy() {
        FeatureUsageDetail _x = new FeatureUsageDetail();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.featureName = featureName;
        _x.licenseRequired = licenseRequired;
        _x.licenseAssigned = licenseAssigned;
        _x.lastUsedDateTime = lastUsedDateTime;
        _x.lastConfiguredDateTime = lastConfiguredDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("FeatureUsageDetail[");
        b.append("featureName=");
        b.append(this.featureName);
        b.append(", ");
        b.append("licenseRequired=");
        b.append(this.licenseRequired);
        b.append(", ");
        b.append("licenseAssigned=");
        b.append(this.licenseAssigned);
        b.append(", ");
        b.append("lastUsedDateTime=");
        b.append(this.lastUsedDateTime);
        b.append(", ");
        b.append("lastConfiguredDateTime=");
        b.append(this.lastConfiguredDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
