package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "classification", 
    "errors"})
@JsonInclude(Include.NON_NULL)
public class ExactMatchClassificationResult implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("classification")
    protected List<ExactMatchDetectedSensitiveContent> classification;

    @JsonProperty("classification@nextLink")
    protected String classificationNextLink;

    @JsonProperty("errors")
    protected List<ClassificationError> errors;

    @JsonProperty("errors@nextLink")
    protected String errorsNextLink;

    protected ExactMatchClassificationResult() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.exactMatchClassificationResult";
    }

    @Property(name="classification")
    @JsonIgnore
    public CollectionPage<ExactMatchDetectedSensitiveContent> getClassification() {
        return new CollectionPage<ExactMatchDetectedSensitiveContent>(contextPath, ExactMatchDetectedSensitiveContent.class, classification, Optional.ofNullable(classificationNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="classification")
    @JsonIgnore
    public CollectionPage<ExactMatchDetectedSensitiveContent> getClassification(HttpRequestOptions options) {
        return new CollectionPage<ExactMatchDetectedSensitiveContent>(contextPath, ExactMatchDetectedSensitiveContent.class, classification, Optional.ofNullable(classificationNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="errors")
    @JsonIgnore
    public CollectionPage<ClassificationError> getErrors() {
        return new CollectionPage<ClassificationError>(contextPath, ClassificationError.class, errors, Optional.ofNullable(errorsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="errors")
    @JsonIgnore
    public CollectionPage<ClassificationError> getErrors(HttpRequestOptions options) {
        return new CollectionPage<ClassificationError>(contextPath, ClassificationError.class, errors, Optional.ofNullable(errorsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<ExactMatchDetectedSensitiveContent> classification;
        private String classificationNextLink;
        private List<ClassificationError> errors;
        private String errorsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder classification(List<ExactMatchDetectedSensitiveContent> classification) {
            this.classification = classification;
            this.changedFields = changedFields.add("classification");
            return this;
        }

        public Builder classification(ExactMatchDetectedSensitiveContent... classification) {
            return classification(Arrays.asList(classification));
        }

        public Builder classificationNextLink(String classificationNextLink) {
            this.classificationNextLink = classificationNextLink;
            this.changedFields = changedFields.add("classification");
            return this;
        }

        public Builder errors(List<ClassificationError> errors) {
            this.errors = errors;
            this.changedFields = changedFields.add("errors");
            return this;
        }

        public Builder errors(ClassificationError... errors) {
            return errors(Arrays.asList(errors));
        }

        public Builder errorsNextLink(String errorsNextLink) {
            this.errorsNextLink = errorsNextLink;
            this.changedFields = changedFields.add("errors");
            return this;
        }

        public ExactMatchClassificationResult build() {
            ExactMatchClassificationResult _x = new ExactMatchClassificationResult();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.exactMatchClassificationResult";
            _x.classification = classification;
            _x.classificationNextLink = classificationNextLink;
            _x.errors = errors;
            _x.errorsNextLink = errorsNextLink;
            return _x;
        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ExactMatchClassificationResult[");
        b.append("classification=");
        b.append(this.classification);
        b.append(", ");
        b.append("errors=");
        b.append(this.errors);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
