package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "sensitiveTypeIds", 
    "text", 
    "timeoutInMs", 
    "contentClassifications"})
@JsonInclude(Include.NON_NULL)
public class ExactMatchClassificationRequest implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("sensitiveTypeIds")
    protected List<String> sensitiveTypeIds;

    @JsonProperty("sensitiveTypeIds@nextLink")
    protected String sensitiveTypeIdsNextLink;

    @JsonProperty("text")
    protected String text;

    @JsonProperty("timeoutInMs")
    protected Integer timeoutInMs;

    @JsonProperty("contentClassifications")
    protected List<ContentClassification> contentClassifications;

    @JsonProperty("contentClassifications@nextLink")
    protected String contentClassificationsNextLink;

    protected ExactMatchClassificationRequest() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.exactMatchClassificationRequest";
    }

    @Property(name="sensitiveTypeIds")
    @JsonIgnore
    public CollectionPage<String> getSensitiveTypeIds() {
        return new CollectionPage<String>(contextPath, String.class, sensitiveTypeIds, Optional.ofNullable(sensitiveTypeIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="sensitiveTypeIds")
    @JsonIgnore
    public CollectionPage<String> getSensitiveTypeIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, sensitiveTypeIds, Optional.ofNullable(sensitiveTypeIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="text")
    @JsonIgnore
    public Optional<String> getText() {
        return Optional.ofNullable(text);
    }

    public ExactMatchClassificationRequest withText(String text) {
        ExactMatchClassificationRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.exactMatchClassificationRequest");
        _x.text = text;
        return _x;
    }

    @Property(name="timeoutInMs")
    @JsonIgnore
    public Optional<Integer> getTimeoutInMs() {
        return Optional.ofNullable(timeoutInMs);
    }

    public ExactMatchClassificationRequest withTimeoutInMs(Integer timeoutInMs) {
        ExactMatchClassificationRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.exactMatchClassificationRequest");
        _x.timeoutInMs = timeoutInMs;
        return _x;
    }

    @Property(name="contentClassifications")
    @JsonIgnore
    public CollectionPage<ContentClassification> getContentClassifications() {
        return new CollectionPage<ContentClassification>(contextPath, ContentClassification.class, contentClassifications, Optional.ofNullable(contentClassificationsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="contentClassifications")
    @JsonIgnore
    public CollectionPage<ContentClassification> getContentClassifications(HttpRequestOptions options) {
        return new CollectionPage<ContentClassification>(contextPath, ContentClassification.class, contentClassifications, Optional.ofNullable(contentClassificationsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> sensitiveTypeIds;
        private String sensitiveTypeIdsNextLink;
        private String text;
        private Integer timeoutInMs;
        private List<ContentClassification> contentClassifications;
        private String contentClassificationsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder sensitiveTypeIds(List<String> sensitiveTypeIds) {
            this.sensitiveTypeIds = sensitiveTypeIds;
            this.changedFields = changedFields.add("sensitiveTypeIds");
            return this;
        }

        public Builder sensitiveTypeIds(String... sensitiveTypeIds) {
            return sensitiveTypeIds(Arrays.asList(sensitiveTypeIds));
        }

        public Builder sensitiveTypeIdsNextLink(String sensitiveTypeIdsNextLink) {
            this.sensitiveTypeIdsNextLink = sensitiveTypeIdsNextLink;
            this.changedFields = changedFields.add("sensitiveTypeIds");
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            this.changedFields = changedFields.add("text");
            return this;
        }

        public Builder timeoutInMs(Integer timeoutInMs) {
            this.timeoutInMs = timeoutInMs;
            this.changedFields = changedFields.add("timeoutInMs");
            return this;
        }

        public Builder contentClassifications(List<ContentClassification> contentClassifications) {
            this.contentClassifications = contentClassifications;
            this.changedFields = changedFields.add("contentClassifications");
            return this;
        }

        public Builder contentClassifications(ContentClassification... contentClassifications) {
            return contentClassifications(Arrays.asList(contentClassifications));
        }

        public Builder contentClassificationsNextLink(String contentClassificationsNextLink) {
            this.contentClassificationsNextLink = contentClassificationsNextLink;
            this.changedFields = changedFields.add("contentClassifications");
            return this;
        }

        public ExactMatchClassificationRequest build() {
            ExactMatchClassificationRequest _x = new ExactMatchClassificationRequest();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.exactMatchClassificationRequest";
            _x.sensitiveTypeIds = sensitiveTypeIds;
            _x.sensitiveTypeIdsNextLink = sensitiveTypeIdsNextLink;
            _x.text = text;
            _x.timeoutInMs = timeoutInMs;
            _x.contentClassifications = contentClassifications;
            _x.contentClassificationsNextLink = contentClassificationsNextLink;
            return _x;
        }
    }

    private ExactMatchClassificationRequest _copy() {
        ExactMatchClassificationRequest _x = new ExactMatchClassificationRequest();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.sensitiveTypeIds = sensitiveTypeIds;
        _x.text = text;
        _x.timeoutInMs = timeoutInMs;
        _x.contentClassifications = contentClassifications;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ExactMatchClassificationRequest[");
        b.append("sensitiveTypeIds=");
        b.append(this.sensitiveTypeIds);
        b.append(", ");
        b.append("text=");
        b.append(this.text);
        b.append(", ");
        b.append("timeoutInMs=");
        b.append(this.timeoutInMs);
        b.append(", ");
        b.append("contentClassifications=");
        b.append(this.contentClassifications);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
