package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "sensitivityLabelsResult", 
    "dataLossPreventionPoliciesResult", 
    "classificationResult"})
@JsonInclude(Include.NON_NULL)
public class EvaluateLabelsAndPoliciesResult implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("sensitivityLabelsResult")
    protected EvaluateLabelJobResultGroup sensitivityLabelsResult;

    @JsonProperty("dataLossPreventionPoliciesResult")
    protected DlpPoliciesJobResult dataLossPreventionPoliciesResult;

    @JsonProperty("classificationResult")
    protected DetectedSensitiveContentWrapper classificationResult;

    protected EvaluateLabelsAndPoliciesResult() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.evaluateLabelsAndPoliciesResult";
    }

    @Property(name="sensitivityLabelsResult")
    @JsonIgnore
    public Optional<EvaluateLabelJobResultGroup> getSensitivityLabelsResult() {
        return Optional.ofNullable(sensitivityLabelsResult);
    }

    public EvaluateLabelsAndPoliciesResult withSensitivityLabelsResult(EvaluateLabelJobResultGroup sensitivityLabelsResult) {
        EvaluateLabelsAndPoliciesResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.evaluateLabelsAndPoliciesResult");
        _x.sensitivityLabelsResult = sensitivityLabelsResult;
        return _x;
    }

    @Property(name="dataLossPreventionPoliciesResult")
    @JsonIgnore
    public Optional<DlpPoliciesJobResult> getDataLossPreventionPoliciesResult() {
        return Optional.ofNullable(dataLossPreventionPoliciesResult);
    }

    public EvaluateLabelsAndPoliciesResult withDataLossPreventionPoliciesResult(DlpPoliciesJobResult dataLossPreventionPoliciesResult) {
        EvaluateLabelsAndPoliciesResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.evaluateLabelsAndPoliciesResult");
        _x.dataLossPreventionPoliciesResult = dataLossPreventionPoliciesResult;
        return _x;
    }

    @Property(name="classificationResult")
    @JsonIgnore
    public Optional<DetectedSensitiveContentWrapper> getClassificationResult() {
        return Optional.ofNullable(classificationResult);
    }

    public EvaluateLabelsAndPoliciesResult withClassificationResult(DetectedSensitiveContentWrapper classificationResult) {
        EvaluateLabelsAndPoliciesResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.evaluateLabelsAndPoliciesResult");
        _x.classificationResult = classificationResult;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private EvaluateLabelJobResultGroup sensitivityLabelsResult;
        private DlpPoliciesJobResult dataLossPreventionPoliciesResult;
        private DetectedSensitiveContentWrapper classificationResult;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder sensitivityLabelsResult(EvaluateLabelJobResultGroup sensitivityLabelsResult) {
            this.sensitivityLabelsResult = sensitivityLabelsResult;
            this.changedFields = changedFields.add("sensitivityLabelsResult");
            return this;
        }

        public Builder dataLossPreventionPoliciesResult(DlpPoliciesJobResult dataLossPreventionPoliciesResult) {
            this.dataLossPreventionPoliciesResult = dataLossPreventionPoliciesResult;
            this.changedFields = changedFields.add("dataLossPreventionPoliciesResult");
            return this;
        }

        public Builder classificationResult(DetectedSensitiveContentWrapper classificationResult) {
            this.classificationResult = classificationResult;
            this.changedFields = changedFields.add("classificationResult");
            return this;
        }

        public EvaluateLabelsAndPoliciesResult build() {
            EvaluateLabelsAndPoliciesResult _x = new EvaluateLabelsAndPoliciesResult();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.evaluateLabelsAndPoliciesResult";
            _x.sensitivityLabelsResult = sensitivityLabelsResult;
            _x.dataLossPreventionPoliciesResult = dataLossPreventionPoliciesResult;
            _x.classificationResult = classificationResult;
            return _x;
        }
    }

    private EvaluateLabelsAndPoliciesResult _copy() {
        EvaluateLabelsAndPoliciesResult _x = new EvaluateLabelsAndPoliciesResult();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.sensitivityLabelsResult = sensitivityLabelsResult;
        _x.dataLossPreventionPoliciesResult = dataLossPreventionPoliciesResult;
        _x.classificationResult = classificationResult;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EvaluateLabelsAndPoliciesResult[");
        b.append("sensitivityLabelsResult=");
        b.append(this.sensitivityLabelsResult);
        b.append(", ");
        b.append("dataLossPreventionPoliciesResult=");
        b.append(this.dataLossPreventionPoliciesResult);
        b.append(", ");
        b.append("classificationResult=");
        b.append(this.classificationResult);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
