package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "errorCode", 
    "message", 
    "details"})
@JsonInclude(Include.NON_NULL)
public class ErrorDetail implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("errorCode")
    protected String errorCode;

    @JsonProperty("message")
    protected String message;

    @JsonProperty("details")
    protected List<InnerErrorDetail> details;

    @JsonProperty("details@nextLink")
    protected String detailsNextLink;

    protected ErrorDetail() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.errorDetail";
    }

    @Property(name="errorCode")
    @JsonIgnore
    public Optional<String> getErrorCode() {
        return Optional.ofNullable(errorCode);
    }

    public ErrorDetail withErrorCode(String errorCode) {
        ErrorDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.errorDetail");
        _x.errorCode = errorCode;
        return _x;
    }

    @Property(name="message")
    @JsonIgnore
    public Optional<String> getMessage() {
        return Optional.ofNullable(message);
    }

    public ErrorDetail withMessage(String message) {
        ErrorDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.errorDetail");
        _x.message = message;
        return _x;
    }

    @Property(name="details")
    @JsonIgnore
    public CollectionPage<InnerErrorDetail> getDetails() {
        return new CollectionPage<InnerErrorDetail>(contextPath, InnerErrorDetail.class, details, Optional.ofNullable(detailsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="details")
    @JsonIgnore
    public CollectionPage<InnerErrorDetail> getDetails(HttpRequestOptions options) {
        return new CollectionPage<InnerErrorDetail>(contextPath, InnerErrorDetail.class, details, Optional.ofNullable(detailsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String errorCode;
        private String message;
        private List<InnerErrorDetail> details;
        private String detailsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            this.changedFields = changedFields.add("errorCode");
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            this.changedFields = changedFields.add("message");
            return this;
        }

        public Builder details(List<InnerErrorDetail> details) {
            this.details = details;
            this.changedFields = changedFields.add("details");
            return this;
        }

        public Builder details(InnerErrorDetail... details) {
            return details(Arrays.asList(details));
        }

        public Builder detailsNextLink(String detailsNextLink) {
            this.detailsNextLink = detailsNextLink;
            this.changedFields = changedFields.add("details");
            return this;
        }

        public ErrorDetail build() {
            ErrorDetail _x = new ErrorDetail();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.errorDetail";
            _x.errorCode = errorCode;
            _x.message = message;
            _x.details = details;
            _x.detailsNextLink = detailsNextLink;
            return _x;
        }
    }

    private ErrorDetail _copy() {
        ErrorDetail _x = new ErrorDetail();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.errorCode = errorCode;
        _x.message = message;
        _x.details = details;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ErrorDetail[");
        b.append("errorCode=");
        b.append(this.errorCode);
        b.append(", ");
        b.append("message=");
        b.append(this.message);
        b.append(", ");
        b.append("details=");
        b.append(this.details);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
