package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.EncryptWith;

@JsonPropertyOrder({
    "@odata.type", 
    "decryptionRightsManagementTemplateId", 
    "allowMailForwarding", 
    "allowAdHocPermissions"})
@JsonInclude(Include.NON_NULL)
public class EncryptWithUserDefinedRights extends EncryptContent implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("decryptionRightsManagementTemplateId")
    protected String decryptionRightsManagementTemplateId;

    @JsonProperty("allowMailForwarding")
    protected Boolean allowMailForwarding;

    @JsonProperty("allowAdHocPermissions")
    protected Boolean allowAdHocPermissions;

    protected EncryptWithUserDefinedRights() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.encryptWithUserDefinedRights";
    }

    @Property(name="decryptionRightsManagementTemplateId")
    @JsonIgnore
    public Optional<String> getDecryptionRightsManagementTemplateId() {
        return Optional.ofNullable(decryptionRightsManagementTemplateId);
    }

    public EncryptWithUserDefinedRights withDecryptionRightsManagementTemplateId(String decryptionRightsManagementTemplateId) {
        EncryptWithUserDefinedRights _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.encryptWithUserDefinedRights");
        _x.decryptionRightsManagementTemplateId = decryptionRightsManagementTemplateId;
        return _x;
    }

    @Property(name="allowMailForwarding")
    @JsonIgnore
    public Optional<Boolean> getAllowMailForwarding() {
        return Optional.ofNullable(allowMailForwarding);
    }

    public EncryptWithUserDefinedRights withAllowMailForwarding(Boolean allowMailForwarding) {
        EncryptWithUserDefinedRights _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.encryptWithUserDefinedRights");
        _x.allowMailForwarding = allowMailForwarding;
        return _x;
    }

    @Property(name="allowAdHocPermissions")
    @JsonIgnore
    public Optional<Boolean> getAllowAdHocPermissions() {
        return Optional.ofNullable(allowAdHocPermissions);
    }

    public EncryptWithUserDefinedRights withAllowAdHocPermissions(Boolean allowAdHocPermissions) {
        EncryptWithUserDefinedRights _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.encryptWithUserDefinedRights");
        _x.allowAdHocPermissions = allowAdHocPermissions;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEncryptWithUserDefinedRights() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private EncryptWith encryptWith;
        private String decryptionRightsManagementTemplateId;
        private Boolean allowMailForwarding;
        private Boolean allowAdHocPermissions;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder encryptWith(EncryptWith encryptWith) {
            this.encryptWith = encryptWith;
            this.changedFields = changedFields.add("encryptWith");
            return this;
        }

        public Builder decryptionRightsManagementTemplateId(String decryptionRightsManagementTemplateId) {
            this.decryptionRightsManagementTemplateId = decryptionRightsManagementTemplateId;
            this.changedFields = changedFields.add("decryptionRightsManagementTemplateId");
            return this;
        }

        public Builder allowMailForwarding(Boolean allowMailForwarding) {
            this.allowMailForwarding = allowMailForwarding;
            this.changedFields = changedFields.add("allowMailForwarding");
            return this;
        }

        public Builder allowAdHocPermissions(Boolean allowAdHocPermissions) {
            this.allowAdHocPermissions = allowAdHocPermissions;
            this.changedFields = changedFields.add("allowAdHocPermissions");
            return this;
        }

        public EncryptWithUserDefinedRights build() {
            EncryptWithUserDefinedRights _x = new EncryptWithUserDefinedRights();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.encryptWithUserDefinedRights";
            _x.name = name;
            _x.encryptWith = encryptWith;
            _x.decryptionRightsManagementTemplateId = decryptionRightsManagementTemplateId;
            _x.allowMailForwarding = allowMailForwarding;
            _x.allowAdHocPermissions = allowAdHocPermissions;
            return _x;
        }
    }

    private EncryptWithUserDefinedRights _copy() {
        EncryptWithUserDefinedRights _x = new EncryptWithUserDefinedRights();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.name = name;
        _x.encryptWith = encryptWith;
        _x.decryptionRightsManagementTemplateId = decryptionRightsManagementTemplateId;
        _x.allowMailForwarding = allowMailForwarding;
        _x.allowAdHocPermissions = allowAdHocPermissions;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EncryptWithUserDefinedRights[");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("encryptWith=");
        b.append(this.encryptWith);
        b.append(", ");
        b.append("decryptionRightsManagementTemplateId=");
        b.append(this.decryptionRightsManagementTemplateId);
        b.append(", ");
        b.append("allowMailForwarding=");
        b.append(this.allowMailForwarding);
        b.append(", ");
        b.append("allowAdHocPermissions=");
        b.append(this.allowAdHocPermissions);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
