package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


/**
 * <i>“The embedded SIM activation code as provided by the mobile operator.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "integratedCircuitCardIdentifier", 
    "matchingIdentifier", 
    "smdpPlusServerAddress"})
@JsonInclude(Include.NON_NULL)
public class EmbeddedSIMActivationCode implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("integratedCircuitCardIdentifier")
    protected String integratedCircuitCardIdentifier;

    @JsonProperty("matchingIdentifier")
    protected String matchingIdentifier;

    @JsonProperty("smdpPlusServerAddress")
    protected String smdpPlusServerAddress;

    protected EmbeddedSIMActivationCode() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.embeddedSIMActivationCode";
    }

    /**
     * <i>“The input must match the following regular expression: '^[0-9]{19}[0-9]?$'.”</i>
     * 
     * @return property integratedCircuitCardIdentifier
     */
    @Property(name="integratedCircuitCardIdentifier")
    @JsonIgnore
    public Optional<String> getIntegratedCircuitCardIdentifier() {
        return Optional.ofNullable(integratedCircuitCardIdentifier);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * integratedCircuitCardIdentifier} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“The input must match the following regular expression: '^[0-9]{19}[0-9]?$'.”</i>
     * 
     * @param integratedCircuitCardIdentifier
     *            new value of {@code integratedCircuitCardIdentifier} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code integratedCircuitCardIdentifier} field changed
     */
    public EmbeddedSIMActivationCode withIntegratedCircuitCardIdentifier(String integratedCircuitCardIdentifier) {
        EmbeddedSIMActivationCode _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.embeddedSIMActivationCode");
        _x.integratedCircuitCardIdentifier = integratedCircuitCardIdentifier;
        return _x;
    }

    /**
     * <i>“The input must match the following regular expression: '^[a-zA-Z0-9{@literal \}-]*$'.”</i>
     * 
     * @return property matchingIdentifier
     */
    @Property(name="matchingIdentifier")
    @JsonIgnore
    public Optional<String> getMatchingIdentifier() {
        return Optional.ofNullable(matchingIdentifier);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * matchingIdentifier} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The input must match the following regular expression: '^[a-zA-Z0-9{@literal \}-]*$'.”</i>
     * 
     * @param matchingIdentifier
     *            new value of {@code matchingIdentifier} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code matchingIdentifier} field changed
     */
    public EmbeddedSIMActivationCode withMatchingIdentifier(String matchingIdentifier) {
        EmbeddedSIMActivationCode _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.embeddedSIMActivationCode");
        _x.matchingIdentifier = matchingIdentifier;
        return _x;
    }

    /**
     * <i>“The input must match the following regular expression: '^([a-zA-Z0-9]+(-[a-zA-Z0
     * -9]+)*{@literal \}.)+[a-zA-Z]{2,}$'.”</i>
     * 
     * @return property smdpPlusServerAddress
     */
    @Property(name="smdpPlusServerAddress")
    @JsonIgnore
    public Optional<String> getSmdpPlusServerAddress() {
        return Optional.ofNullable(smdpPlusServerAddress);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * smdpPlusServerAddress} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The input must match the following regular expression: '^([a-zA-Z0-9]+(-[a-zA-Z0
     * -9]+)*{@literal \}.)+[a-zA-Z]{2,}$'.”</i>
     * 
     * @param smdpPlusServerAddress
     *            new value of {@code smdpPlusServerAddress} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code smdpPlusServerAddress} field changed
     */
    public EmbeddedSIMActivationCode withSmdpPlusServerAddress(String smdpPlusServerAddress) {
        EmbeddedSIMActivationCode _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.embeddedSIMActivationCode");
        _x.smdpPlusServerAddress = smdpPlusServerAddress;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String integratedCircuitCardIdentifier;
        private String matchingIdentifier;
        private String smdpPlusServerAddress;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The input must match the following regular expression: '^[0-9]{19}[0-9]?$'.”</i>
         * 
         * @param integratedCircuitCardIdentifier
         *            value of {@code integratedCircuitCardIdentifier} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder integratedCircuitCardIdentifier(String integratedCircuitCardIdentifier) {
            this.integratedCircuitCardIdentifier = integratedCircuitCardIdentifier;
            this.changedFields = changedFields.add("integratedCircuitCardIdentifier");
            return this;
        }

        /**
         * <i>“The input must match the following regular expression: '^[a-zA-Z0-9{@literal \}-]*$'.”</i>
         * 
         * @param matchingIdentifier
         *            value of {@code matchingIdentifier} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder matchingIdentifier(String matchingIdentifier) {
            this.matchingIdentifier = matchingIdentifier;
            this.changedFields = changedFields.add("matchingIdentifier");
            return this;
        }

        /**
         * <i>“The input must match the following regular expression: '^([a-zA-Z0-9]+(-[a-zA-Z0
         * -9]+)*{@literal \}.)+[a-zA-Z]{2,}$'.”</i>
         * 
         * @param smdpPlusServerAddress
         *            value of {@code smdpPlusServerAddress} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder smdpPlusServerAddress(String smdpPlusServerAddress) {
            this.smdpPlusServerAddress = smdpPlusServerAddress;
            this.changedFields = changedFields.add("smdpPlusServerAddress");
            return this;
        }

        public EmbeddedSIMActivationCode build() {
            EmbeddedSIMActivationCode _x = new EmbeddedSIMActivationCode();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.embeddedSIMActivationCode";
            _x.integratedCircuitCardIdentifier = integratedCircuitCardIdentifier;
            _x.matchingIdentifier = matchingIdentifier;
            _x.smdpPlusServerAddress = smdpPlusServerAddress;
            return _x;
        }
    }

    private EmbeddedSIMActivationCode _copy() {
        EmbeddedSIMActivationCode _x = new EmbeddedSIMActivationCode();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.integratedCircuitCardIdentifier = integratedCircuitCardIdentifier;
        _x.matchingIdentifier = matchingIdentifier;
        _x.smdpPlusServerAddress = smdpPlusServerAddress;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EmbeddedSIMActivationCode[");
        b.append("integratedCircuitCardIdentifier=");
        b.append(this.integratedCircuitCardIdentifier);
        b.append(", ");
        b.append("matchingIdentifier=");
        b.append(this.matchingIdentifier);
        b.append(", ");
        b.append("smdpPlusServerAddress=");
        b.append(this.smdpPlusServerAddress);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
