package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "name", 
    "address"})
@JsonInclude(Include.NON_NULL)
public class EmailAddress implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("address")
    protected String address;

    protected EmailAddress() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.emailAddress";
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public EmailAddress withName(String name) {
        EmailAddress _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.emailAddress");
        _x.name = name;
        return _x;
    }

    @Property(name="address")
    @JsonIgnore
    public Optional<String> getAddress() {
        return Optional.ofNullable(address);
    }

    public EmailAddress withAddress(String address) {
        EmailAddress _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.emailAddress");
        _x.address = address;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private String address;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder address(String address) {
            this.address = address;
            this.changedFields = changedFields.add("address");
            return this;
        }

        public EmailAddress build() {
            EmailAddress _x = new EmailAddress();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.emailAddress";
            _x.name = name;
            _x.address = address;
            return _x;
        }
    }

    private EmailAddress _copy() {
        EmailAddress _x = new EmailAddress();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.name = name;
        _x.address = address;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EmailAddress[");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("address=");
        b.append(this.address);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
