package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "abbreviation", 
    "activities", 
    "awards", 
    "description", 
    "displayName", 
    "fieldsOfStudy", 
    "grade", 
    "notes", 
    "webUrl"})
@JsonInclude(Include.NON_NULL)
public class EducationalActivityDetail implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("abbreviation")
    protected String abbreviation;

    @JsonProperty("activities")
    protected String activities;

    @JsonProperty("awards")
    protected String awards;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("fieldsOfStudy")
    protected String fieldsOfStudy;

    @JsonProperty("grade")
    protected String grade;

    @JsonProperty("notes")
    protected String notes;

    @JsonProperty("webUrl")
    protected String webUrl;

    protected EducationalActivityDetail() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.educationalActivityDetail";
    }

    @Property(name="abbreviation")
    @JsonIgnore
    public Optional<String> getAbbreviation() {
        return Optional.ofNullable(abbreviation);
    }

    public EducationalActivityDetail withAbbreviation(String abbreviation) {
        EducationalActivityDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationalActivityDetail");
        _x.abbreviation = abbreviation;
        return _x;
    }

    @Property(name="activities")
    @JsonIgnore
    public Optional<String> getActivities() {
        return Optional.ofNullable(activities);
    }

    public EducationalActivityDetail withActivities(String activities) {
        EducationalActivityDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationalActivityDetail");
        _x.activities = activities;
        return _x;
    }

    @Property(name="awards")
    @JsonIgnore
    public Optional<String> getAwards() {
        return Optional.ofNullable(awards);
    }

    public EducationalActivityDetail withAwards(String awards) {
        EducationalActivityDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationalActivityDetail");
        _x.awards = awards;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public EducationalActivityDetail withDescription(String description) {
        EducationalActivityDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationalActivityDetail");
        _x.description = description;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public EducationalActivityDetail withDisplayName(String displayName) {
        EducationalActivityDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationalActivityDetail");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="fieldsOfStudy")
    @JsonIgnore
    public Optional<String> getFieldsOfStudy() {
        return Optional.ofNullable(fieldsOfStudy);
    }

    public EducationalActivityDetail withFieldsOfStudy(String fieldsOfStudy) {
        EducationalActivityDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationalActivityDetail");
        _x.fieldsOfStudy = fieldsOfStudy;
        return _x;
    }

    @Property(name="grade")
    @JsonIgnore
    public Optional<String> getGrade() {
        return Optional.ofNullable(grade);
    }

    public EducationalActivityDetail withGrade(String grade) {
        EducationalActivityDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationalActivityDetail");
        _x.grade = grade;
        return _x;
    }

    @Property(name="notes")
    @JsonIgnore
    public Optional<String> getNotes() {
        return Optional.ofNullable(notes);
    }

    public EducationalActivityDetail withNotes(String notes) {
        EducationalActivityDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationalActivityDetail");
        _x.notes = notes;
        return _x;
    }

    @Property(name="webUrl")
    @JsonIgnore
    public Optional<String> getWebUrl() {
        return Optional.ofNullable(webUrl);
    }

    public EducationalActivityDetail withWebUrl(String webUrl) {
        EducationalActivityDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationalActivityDetail");
        _x.webUrl = webUrl;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String abbreviation;
        private String activities;
        private String awards;
        private String description;
        private String displayName;
        private String fieldsOfStudy;
        private String grade;
        private String notes;
        private String webUrl;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder abbreviation(String abbreviation) {
            this.abbreviation = abbreviation;
            this.changedFields = changedFields.add("abbreviation");
            return this;
        }

        public Builder activities(String activities) {
            this.activities = activities;
            this.changedFields = changedFields.add("activities");
            return this;
        }

        public Builder awards(String awards) {
            this.awards = awards;
            this.changedFields = changedFields.add("awards");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder fieldsOfStudy(String fieldsOfStudy) {
            this.fieldsOfStudy = fieldsOfStudy;
            this.changedFields = changedFields.add("fieldsOfStudy");
            return this;
        }

        public Builder grade(String grade) {
            this.grade = grade;
            this.changedFields = changedFields.add("grade");
            return this;
        }

        public Builder notes(String notes) {
            this.notes = notes;
            this.changedFields = changedFields.add("notes");
            return this;
        }

        public Builder webUrl(String webUrl) {
            this.webUrl = webUrl;
            this.changedFields = changedFields.add("webUrl");
            return this;
        }

        public EducationalActivityDetail build() {
            EducationalActivityDetail _x = new EducationalActivityDetail();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.educationalActivityDetail";
            _x.abbreviation = abbreviation;
            _x.activities = activities;
            _x.awards = awards;
            _x.description = description;
            _x.displayName = displayName;
            _x.fieldsOfStudy = fieldsOfStudy;
            _x.grade = grade;
            _x.notes = notes;
            _x.webUrl = webUrl;
            return _x;
        }
    }

    private EducationalActivityDetail _copy() {
        EducationalActivityDetail _x = new EducationalActivityDetail();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.abbreviation = abbreviation;
        _x.activities = activities;
        _x.awards = awards;
        _x.description = description;
        _x.displayName = displayName;
        _x.fieldsOfStudy = fieldsOfStudy;
        _x.grade = grade;
        _x.notes = notes;
        _x.webUrl = webUrl;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EducationalActivityDetail[");
        b.append("abbreviation=");
        b.append(this.abbreviation);
        b.append(", ");
        b.append("activities=");
        b.append(this.activities);
        b.append(", ");
        b.append("awards=");
        b.append(this.awards);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("fieldsOfStudy=");
        b.append(this.fieldsOfStudy);
        b.append(", ");
        b.append("grade=");
        b.append(this.grade);
        b.append(", ");
        b.append("notes=");
        b.append(this.notes);
        b.append(", ");
        b.append("webUrl=");
        b.append(this.webUrl);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
