package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.LocalDate;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "externalId", 
    "startDate", 
    "endDate", 
    "displayName"})
@JsonInclude(Include.NON_NULL)
public class EducationTerm implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("externalId")
    protected String externalId;

    @JsonProperty("startDate")
    protected LocalDate startDate;

    @JsonProperty("endDate")
    protected LocalDate endDate;

    @JsonProperty("displayName")
    protected String displayName;

    protected EducationTerm() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.educationTerm";
    }

    @Property(name="externalId")
    @JsonIgnore
    public Optional<String> getExternalId() {
        return Optional.ofNullable(externalId);
    }

    public EducationTerm withExternalId(String externalId) {
        EducationTerm _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationTerm");
        _x.externalId = externalId;
        return _x;
    }

    @Property(name="startDate")
    @JsonIgnore
    public Optional<LocalDate> getStartDate() {
        return Optional.ofNullable(startDate);
    }

    public EducationTerm withStartDate(LocalDate startDate) {
        EducationTerm _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationTerm");
        _x.startDate = startDate;
        return _x;
    }

    @Property(name="endDate")
    @JsonIgnore
    public Optional<LocalDate> getEndDate() {
        return Optional.ofNullable(endDate);
    }

    public EducationTerm withEndDate(LocalDate endDate) {
        EducationTerm _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationTerm");
        _x.endDate = endDate;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public EducationTerm withDisplayName(String displayName) {
        EducationTerm _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationTerm");
        _x.displayName = displayName;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String externalId;
        private LocalDate startDate;
        private LocalDate endDate;
        private String displayName;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder externalId(String externalId) {
            this.externalId = externalId;
            this.changedFields = changedFields.add("externalId");
            return this;
        }

        public Builder startDate(LocalDate startDate) {
            this.startDate = startDate;
            this.changedFields = changedFields.add("startDate");
            return this;
        }

        public Builder endDate(LocalDate endDate) {
            this.endDate = endDate;
            this.changedFields = changedFields.add("endDate");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public EducationTerm build() {
            EducationTerm _x = new EducationTerm();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.educationTerm";
            _x.externalId = externalId;
            _x.startDate = startDate;
            _x.endDate = endDate;
            _x.displayName = displayName;
            return _x;
        }
    }

    private EducationTerm _copy() {
        EducationTerm _x = new EducationTerm();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.externalId = externalId;
        _x.startDate = startDate;
        _x.endDate = endDate;
        _x.displayName = displayName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EducationTerm[");
        b.append("externalId=");
        b.append(this.externalId);
        b.append(", ");
        b.append("startDate=");
        b.append(this.startDate);
        b.append(", ");
        b.append("endDate=");
        b.append(this.endDate);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
