package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "tokenUrl", 
    "scope"})
@JsonInclude(Include.NON_NULL)
public class EducationSynchronizationOAuth2ClientCredentialsConnectionSettings extends EducationSynchronizationConnectionSettings implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("tokenUrl")
    protected String tokenUrl;

    @JsonProperty("scope")
    protected String scope;

    protected EducationSynchronizationOAuth2ClientCredentialsConnectionSettings() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.educationSynchronizationOAuth2ClientCredentialsConnectionSettings";
    }

    @Property(name="tokenUrl")
    @JsonIgnore
    public Optional<String> getTokenUrl() {
        return Optional.ofNullable(tokenUrl);
    }

    public EducationSynchronizationOAuth2ClientCredentialsConnectionSettings withTokenUrl(String tokenUrl) {
        EducationSynchronizationOAuth2ClientCredentialsConnectionSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationSynchronizationOAuth2ClientCredentialsConnectionSettings");
        _x.tokenUrl = tokenUrl;
        return _x;
    }

    @Property(name="scope")
    @JsonIgnore
    public Optional<String> getScope() {
        return Optional.ofNullable(scope);
    }

    public EducationSynchronizationOAuth2ClientCredentialsConnectionSettings withScope(String scope) {
        EducationSynchronizationOAuth2ClientCredentialsConnectionSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationSynchronizationOAuth2ClientCredentialsConnectionSettings");
        _x.scope = scope;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEducationSynchronizationOAuth2ClientCredentialsConnectionSettings() {
        return new Builder();
    }

    public static final class Builder {
        private String clientId;
        private String clientSecret;
        private String tokenUrl;
        private String scope;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder clientId(String clientId) {
            this.clientId = clientId;
            this.changedFields = changedFields.add("clientId");
            return this;
        }

        public Builder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            this.changedFields = changedFields.add("clientSecret");
            return this;
        }

        public Builder tokenUrl(String tokenUrl) {
            this.tokenUrl = tokenUrl;
            this.changedFields = changedFields.add("tokenUrl");
            return this;
        }

        public Builder scope(String scope) {
            this.scope = scope;
            this.changedFields = changedFields.add("scope");
            return this;
        }

        public EducationSynchronizationOAuth2ClientCredentialsConnectionSettings build() {
            EducationSynchronizationOAuth2ClientCredentialsConnectionSettings _x = new EducationSynchronizationOAuth2ClientCredentialsConnectionSettings();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.educationSynchronizationOAuth2ClientCredentialsConnectionSettings";
            _x.clientId = clientId;
            _x.clientSecret = clientSecret;
            _x.tokenUrl = tokenUrl;
            _x.scope = scope;
            return _x;
        }
    }

    private EducationSynchronizationOAuth2ClientCredentialsConnectionSettings _copy() {
        EducationSynchronizationOAuth2ClientCredentialsConnectionSettings _x = new EducationSynchronizationOAuth2ClientCredentialsConnectionSettings();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.clientId = clientId;
        _x.clientSecret = clientSecret;
        _x.tokenUrl = tokenUrl;
        _x.scope = scope;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EducationSynchronizationOAuth2ClientCredentialsConnectionSettings[");
        b.append("clientId=");
        b.append(this.clientId);
        b.append(", ");
        b.append("clientSecret=");
        b.append(this.clientSecret);
        b.append(", ");
        b.append("tokenUrl=");
        b.append(this.tokenUrl);
        b.append(", ");
        b.append("scope=");
        b.append(this.scope);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
