package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "createdDateTime", 
    "createdBy", 
    "lastModifiedDateTime", 
    "lastModifiedBy"})
@JsonInclude(Include.NON_NULL)
public class EducationResource implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("createdBy")
    protected IdentitySet createdBy;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("lastModifiedBy")
    protected IdentitySet lastModifiedBy;

    protected EducationResource() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.educationResource";
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public EducationResource withDisplayName(String displayName) {
        EducationResource _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationResource");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public EducationResource withCreatedDateTime(OffsetDateTime createdDateTime) {
        EducationResource _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationResource");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="createdBy")
    @JsonIgnore
    public Optional<IdentitySet> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    public EducationResource withCreatedBy(IdentitySet createdBy) {
        EducationResource _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationResource");
        _x.createdBy = createdBy;
        return _x;
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public EducationResource withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        EducationResource _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationResource");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Property(name="lastModifiedBy")
    @JsonIgnore
    public Optional<IdentitySet> getLastModifiedBy() {
        return Optional.ofNullable(lastModifiedBy);
    }

    public EducationResource withLastModifiedBy(IdentitySet lastModifiedBy) {
        EducationResource _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationResource");
        _x.lastModifiedBy = lastModifiedBy;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    private EducationResource _copy() {
        EducationResource _x = new EducationResource();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.displayName = displayName;
        _x.createdDateTime = createdDateTime;
        _x.createdBy = createdBy;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.lastModifiedBy = lastModifiedBy;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EducationResource[");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("lastModifiedBy=");
        b.append(this.lastModifiedBy);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
