package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "connectionUrl", 
    "clientId", 
    "clientSecret", 
    "schoolsIds", 
    "schoolYear", 
    "allowTeachersInMultipleSchools", 
    "customizations"})
@JsonInclude(Include.NON_NULL)
public class EducationPowerSchoolDataProvider extends EducationSynchronizationDataProvider implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("connectionUrl")
    protected String connectionUrl;

    @JsonProperty("clientId")
    protected String clientId;

    @JsonProperty("clientSecret")
    protected String clientSecret;

    @JsonProperty("schoolsIds")
    protected List<String> schoolsIds;

    @JsonProperty("schoolsIds@nextLink")
    protected String schoolsIdsNextLink;

    @JsonProperty("schoolYear")
    protected String schoolYear;

    @JsonProperty("allowTeachersInMultipleSchools")
    protected Boolean allowTeachersInMultipleSchools;

    @JsonProperty("customizations")
    protected EducationSynchronizationCustomizations customizations;

    protected EducationPowerSchoolDataProvider() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.educationPowerSchoolDataProvider";
    }

    @Property(name="connectionUrl")
    @JsonIgnore
    public Optional<String> getConnectionUrl() {
        return Optional.ofNullable(connectionUrl);
    }

    public EducationPowerSchoolDataProvider withConnectionUrl(String connectionUrl) {
        EducationPowerSchoolDataProvider _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationPowerSchoolDataProvider");
        _x.connectionUrl = connectionUrl;
        return _x;
    }

    @Property(name="clientId")
    @JsonIgnore
    public Optional<String> getClientId() {
        return Optional.ofNullable(clientId);
    }

    public EducationPowerSchoolDataProvider withClientId(String clientId) {
        EducationPowerSchoolDataProvider _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationPowerSchoolDataProvider");
        _x.clientId = clientId;
        return _x;
    }

    @Property(name="clientSecret")
    @JsonIgnore
    public Optional<String> getClientSecret() {
        return Optional.ofNullable(clientSecret);
    }

    public EducationPowerSchoolDataProvider withClientSecret(String clientSecret) {
        EducationPowerSchoolDataProvider _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationPowerSchoolDataProvider");
        _x.clientSecret = clientSecret;
        return _x;
    }

    @Property(name="schoolsIds")
    @JsonIgnore
    public CollectionPage<String> getSchoolsIds() {
        return new CollectionPage<String>(contextPath, String.class, schoolsIds, Optional.ofNullable(schoolsIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="schoolsIds")
    @JsonIgnore
    public CollectionPage<String> getSchoolsIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, schoolsIds, Optional.ofNullable(schoolsIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="schoolYear")
    @JsonIgnore
    public Optional<String> getSchoolYear() {
        return Optional.ofNullable(schoolYear);
    }

    public EducationPowerSchoolDataProvider withSchoolYear(String schoolYear) {
        EducationPowerSchoolDataProvider _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationPowerSchoolDataProvider");
        _x.schoolYear = schoolYear;
        return _x;
    }

    @Property(name="allowTeachersInMultipleSchools")
    @JsonIgnore
    public Optional<Boolean> getAllowTeachersInMultipleSchools() {
        return Optional.ofNullable(allowTeachersInMultipleSchools);
    }

    public EducationPowerSchoolDataProvider withAllowTeachersInMultipleSchools(Boolean allowTeachersInMultipleSchools) {
        EducationPowerSchoolDataProvider _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationPowerSchoolDataProvider");
        _x.allowTeachersInMultipleSchools = allowTeachersInMultipleSchools;
        return _x;
    }

    @Property(name="customizations")
    @JsonIgnore
    public Optional<EducationSynchronizationCustomizations> getCustomizations() {
        return Optional.ofNullable(customizations);
    }

    public EducationPowerSchoolDataProvider withCustomizations(EducationSynchronizationCustomizations customizations) {
        EducationPowerSchoolDataProvider _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationPowerSchoolDataProvider");
        _x.customizations = customizations;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEducationPowerSchoolDataProvider() {
        return new Builder();
    }

    public static final class Builder {
        private String connectionUrl;
        private String clientId;
        private String clientSecret;
        private List<String> schoolsIds;
        private String schoolsIdsNextLink;
        private String schoolYear;
        private Boolean allowTeachersInMultipleSchools;
        private EducationSynchronizationCustomizations customizations;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder connectionUrl(String connectionUrl) {
            this.connectionUrl = connectionUrl;
            this.changedFields = changedFields.add("connectionUrl");
            return this;
        }

        public Builder clientId(String clientId) {
            this.clientId = clientId;
            this.changedFields = changedFields.add("clientId");
            return this;
        }

        public Builder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            this.changedFields = changedFields.add("clientSecret");
            return this;
        }

        public Builder schoolsIds(List<String> schoolsIds) {
            this.schoolsIds = schoolsIds;
            this.changedFields = changedFields.add("schoolsIds");
            return this;
        }

        public Builder schoolsIds(String... schoolsIds) {
            return schoolsIds(Arrays.asList(schoolsIds));
        }

        public Builder schoolsIdsNextLink(String schoolsIdsNextLink) {
            this.schoolsIdsNextLink = schoolsIdsNextLink;
            this.changedFields = changedFields.add("schoolsIds");
            return this;
        }

        public Builder schoolYear(String schoolYear) {
            this.schoolYear = schoolYear;
            this.changedFields = changedFields.add("schoolYear");
            return this;
        }

        public Builder allowTeachersInMultipleSchools(Boolean allowTeachersInMultipleSchools) {
            this.allowTeachersInMultipleSchools = allowTeachersInMultipleSchools;
            this.changedFields = changedFields.add("allowTeachersInMultipleSchools");
            return this;
        }

        public Builder customizations(EducationSynchronizationCustomizations customizations) {
            this.customizations = customizations;
            this.changedFields = changedFields.add("customizations");
            return this;
        }

        public EducationPowerSchoolDataProvider build() {
            EducationPowerSchoolDataProvider _x = new EducationPowerSchoolDataProvider();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.educationPowerSchoolDataProvider";
            _x.connectionUrl = connectionUrl;
            _x.clientId = clientId;
            _x.clientSecret = clientSecret;
            _x.schoolsIds = schoolsIds;
            _x.schoolsIdsNextLink = schoolsIdsNextLink;
            _x.schoolYear = schoolYear;
            _x.allowTeachersInMultipleSchools = allowTeachersInMultipleSchools;
            _x.customizations = customizations;
            return _x;
        }
    }

    private EducationPowerSchoolDataProvider _copy() {
        EducationPowerSchoolDataProvider _x = new EducationPowerSchoolDataProvider();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.connectionUrl = connectionUrl;
        _x.clientId = clientId;
        _x.clientSecret = clientSecret;
        _x.schoolsIds = schoolsIds;
        _x.schoolYear = schoolYear;
        _x.allowTeachersInMultipleSchools = allowTeachersInMultipleSchools;
        _x.customizations = customizations;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EducationPowerSchoolDataProvider[");
        b.append("connectionUrl=");
        b.append(this.connectionUrl);
        b.append(", ");
        b.append("clientId=");
        b.append(this.clientId);
        b.append(", ");
        b.append("clientSecret=");
        b.append(this.clientSecret);
        b.append(", ");
        b.append("schoolsIds=");
        b.append(this.schoolsIds);
        b.append(", ");
        b.append("schoolYear=");
        b.append(this.schoolYear);
        b.append(", ");
        b.append("allowTeachersInMultipleSchools=");
        b.append(this.allowTeachersInMultipleSchools);
        b.append(", ");
        b.append("customizations=");
        b.append(this.customizations);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
