package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "connectionUrl", 
    "connectionSettings", 
    "schoolsIds", 
    "termIds", 
    "providerName", 
    "customizations"})
@JsonInclude(Include.NON_NULL)
public class EducationOneRosterApiDataProvider extends EducationSynchronizationDataProvider implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("connectionUrl")
    protected String connectionUrl;

    @JsonProperty("connectionSettings")
    protected EducationSynchronizationConnectionSettings connectionSettings;

    @JsonProperty("schoolsIds")
    protected List<String> schoolsIds;

    @JsonProperty("schoolsIds@nextLink")
    protected String schoolsIdsNextLink;

    @JsonProperty("termIds")
    protected List<String> termIds;

    @JsonProperty("termIds@nextLink")
    protected String termIdsNextLink;

    @JsonProperty("providerName")
    protected String providerName;

    @JsonProperty("customizations")
    protected EducationSynchronizationCustomizations customizations;

    protected EducationOneRosterApiDataProvider() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.educationOneRosterApiDataProvider";
    }

    @Property(name="connectionUrl")
    @JsonIgnore
    public Optional<String> getConnectionUrl() {
        return Optional.ofNullable(connectionUrl);
    }

    public EducationOneRosterApiDataProvider withConnectionUrl(String connectionUrl) {
        EducationOneRosterApiDataProvider _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationOneRosterApiDataProvider");
        _x.connectionUrl = connectionUrl;
        return _x;
    }

    @Property(name="connectionSettings")
    @JsonIgnore
    public Optional<EducationSynchronizationConnectionSettings> getConnectionSettings() {
        return Optional.ofNullable(connectionSettings);
    }

    public EducationOneRosterApiDataProvider withConnectionSettings(EducationSynchronizationConnectionSettings connectionSettings) {
        EducationOneRosterApiDataProvider _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationOneRosterApiDataProvider");
        _x.connectionSettings = connectionSettings;
        return _x;
    }

    @Property(name="schoolsIds")
    @JsonIgnore
    public CollectionPage<String> getSchoolsIds() {
        return new CollectionPage<String>(contextPath, String.class, schoolsIds, Optional.ofNullable(schoolsIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="schoolsIds")
    @JsonIgnore
    public CollectionPage<String> getSchoolsIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, schoolsIds, Optional.ofNullable(schoolsIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="termIds")
    @JsonIgnore
    public CollectionPage<String> getTermIds() {
        return new CollectionPage<String>(contextPath, String.class, termIds, Optional.ofNullable(termIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="termIds")
    @JsonIgnore
    public CollectionPage<String> getTermIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, termIds, Optional.ofNullable(termIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="providerName")
    @JsonIgnore
    public Optional<String> getProviderName() {
        return Optional.ofNullable(providerName);
    }

    public EducationOneRosterApiDataProvider withProviderName(String providerName) {
        EducationOneRosterApiDataProvider _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationOneRosterApiDataProvider");
        _x.providerName = providerName;
        return _x;
    }

    @Property(name="customizations")
    @JsonIgnore
    public Optional<EducationSynchronizationCustomizations> getCustomizations() {
        return Optional.ofNullable(customizations);
    }

    public EducationOneRosterApiDataProvider withCustomizations(EducationSynchronizationCustomizations customizations) {
        EducationOneRosterApiDataProvider _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationOneRosterApiDataProvider");
        _x.customizations = customizations;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEducationOneRosterApiDataProvider() {
        return new Builder();
    }

    public static final class Builder {
        private String connectionUrl;
        private EducationSynchronizationConnectionSettings connectionSettings;
        private List<String> schoolsIds;
        private String schoolsIdsNextLink;
        private List<String> termIds;
        private String termIdsNextLink;
        private String providerName;
        private EducationSynchronizationCustomizations customizations;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder connectionUrl(String connectionUrl) {
            this.connectionUrl = connectionUrl;
            this.changedFields = changedFields.add("connectionUrl");
            return this;
        }

        public Builder connectionSettings(EducationSynchronizationConnectionSettings connectionSettings) {
            this.connectionSettings = connectionSettings;
            this.changedFields = changedFields.add("connectionSettings");
            return this;
        }

        public Builder schoolsIds(List<String> schoolsIds) {
            this.schoolsIds = schoolsIds;
            this.changedFields = changedFields.add("schoolsIds");
            return this;
        }

        public Builder schoolsIds(String... schoolsIds) {
            return schoolsIds(Arrays.asList(schoolsIds));
        }

        public Builder schoolsIdsNextLink(String schoolsIdsNextLink) {
            this.schoolsIdsNextLink = schoolsIdsNextLink;
            this.changedFields = changedFields.add("schoolsIds");
            return this;
        }

        public Builder termIds(List<String> termIds) {
            this.termIds = termIds;
            this.changedFields = changedFields.add("termIds");
            return this;
        }

        public Builder termIds(String... termIds) {
            return termIds(Arrays.asList(termIds));
        }

        public Builder termIdsNextLink(String termIdsNextLink) {
            this.termIdsNextLink = termIdsNextLink;
            this.changedFields = changedFields.add("termIds");
            return this;
        }

        public Builder providerName(String providerName) {
            this.providerName = providerName;
            this.changedFields = changedFields.add("providerName");
            return this;
        }

        public Builder customizations(EducationSynchronizationCustomizations customizations) {
            this.customizations = customizations;
            this.changedFields = changedFields.add("customizations");
            return this;
        }

        public EducationOneRosterApiDataProvider build() {
            EducationOneRosterApiDataProvider _x = new EducationOneRosterApiDataProvider();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.educationOneRosterApiDataProvider";
            _x.connectionUrl = connectionUrl;
            _x.connectionSettings = connectionSettings;
            _x.schoolsIds = schoolsIds;
            _x.schoolsIdsNextLink = schoolsIdsNextLink;
            _x.termIds = termIds;
            _x.termIdsNextLink = termIdsNextLink;
            _x.providerName = providerName;
            _x.customizations = customizations;
            return _x;
        }
    }

    private EducationOneRosterApiDataProvider _copy() {
        EducationOneRosterApiDataProvider _x = new EducationOneRosterApiDataProvider();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.connectionUrl = connectionUrl;
        _x.connectionSettings = connectionSettings;
        _x.schoolsIds = schoolsIds;
        _x.termIds = termIds;
        _x.providerName = providerName;
        _x.customizations = customizations;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EducationOneRosterApiDataProvider[");
        b.append("connectionUrl=");
        b.append(this.connectionUrl);
        b.append(", ");
        b.append("connectionSettings=");
        b.append(this.connectionSettings);
        b.append(", ");
        b.append("schoolsIds=");
        b.append(this.schoolsIds);
        b.append(", ");
        b.append("termIds=");
        b.append(this.termIds);
        b.append(", ");
        b.append("providerName=");
        b.append(this.providerName);
        b.append(", ");
        b.append("customizations=");
        b.append(this.customizations);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
