package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "hostWebUrl", 
    "projectId"})
@JsonInclude(Include.NON_NULL)
public class EducationMakeCodeResource extends EducationResource implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("hostWebUrl")
    protected String hostWebUrl;

    @JsonProperty("projectId")
    protected String projectId;

    protected EducationMakeCodeResource() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.educationMakeCodeResource";
    }

    @Property(name="hostWebUrl")
    @JsonIgnore
    public Optional<String> getHostWebUrl() {
        return Optional.ofNullable(hostWebUrl);
    }

    public EducationMakeCodeResource withHostWebUrl(String hostWebUrl) {
        EducationMakeCodeResource _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationMakeCodeResource");
        _x.hostWebUrl = hostWebUrl;
        return _x;
    }

    @Property(name="projectId")
    @JsonIgnore
    public Optional<String> getProjectId() {
        return Optional.ofNullable(projectId);
    }

    public EducationMakeCodeResource withProjectId(String projectId) {
        EducationMakeCodeResource _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationMakeCodeResource");
        _x.projectId = projectId;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEducationMakeCodeResource() {
        return new Builder();
    }

    public static final class Builder {
        private String displayName;
        private OffsetDateTime createdDateTime;
        private IdentitySet createdBy;
        private OffsetDateTime lastModifiedDateTime;
        private IdentitySet lastModifiedBy;
        private String hostWebUrl;
        private String projectId;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder createdBy(IdentitySet createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder lastModifiedBy(IdentitySet lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            this.changedFields = changedFields.add("lastModifiedBy");
            return this;
        }

        public Builder hostWebUrl(String hostWebUrl) {
            this.hostWebUrl = hostWebUrl;
            this.changedFields = changedFields.add("hostWebUrl");
            return this;
        }

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            this.changedFields = changedFields.add("projectId");
            return this;
        }

        public EducationMakeCodeResource build() {
            EducationMakeCodeResource _x = new EducationMakeCodeResource();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.educationMakeCodeResource";
            _x.displayName = displayName;
            _x.createdDateTime = createdDateTime;
            _x.createdBy = createdBy;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.lastModifiedBy = lastModifiedBy;
            _x.hostWebUrl = hostWebUrl;
            _x.projectId = projectId;
            return _x;
        }
    }

    private EducationMakeCodeResource _copy() {
        EducationMakeCodeResource _x = new EducationMakeCodeResource();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.displayName = displayName;
        _x.createdDateTime = createdDateTime;
        _x.createdBy = createdBy;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.lastModifiedBy = lastModifiedBy;
        _x.hostWebUrl = hostWebUrl;
        _x.projectId = projectId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EducationMakeCodeResource[");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("lastModifiedBy=");
        b.append(this.lastModifiedBy);
        b.append(", ");
        b.append("hostWebUrl=");
        b.append(this.hostWebUrl);
        b.append(", ");
        b.append("projectId=");
        b.append(this.projectId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
