package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.EducationUserRole;

@JsonPropertyOrder({
    "@odata.type", 
    "appliesTo", 
    "sourcePropertyName", 
    "targetPropertyName", 
    "targetDomain"})
@JsonInclude(Include.NON_NULL)
public class EducationIdentityMatchingOptions implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("appliesTo")
    protected EducationUserRole appliesTo;

    @JsonProperty("sourcePropertyName")
    protected String sourcePropertyName;

    @JsonProperty("targetPropertyName")
    protected String targetPropertyName;

    @JsonProperty("targetDomain")
    protected String targetDomain;

    protected EducationIdentityMatchingOptions() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.educationIdentityMatchingOptions";
    }

    @Property(name="appliesTo")
    @JsonIgnore
    public Optional<EducationUserRole> getAppliesTo() {
        return Optional.ofNullable(appliesTo);
    }

    public EducationIdentityMatchingOptions withAppliesTo(EducationUserRole appliesTo) {
        EducationIdentityMatchingOptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationIdentityMatchingOptions");
        _x.appliesTo = appliesTo;
        return _x;
    }

    @Property(name="sourcePropertyName")
    @JsonIgnore
    public Optional<String> getSourcePropertyName() {
        return Optional.ofNullable(sourcePropertyName);
    }

    public EducationIdentityMatchingOptions withSourcePropertyName(String sourcePropertyName) {
        EducationIdentityMatchingOptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationIdentityMatchingOptions");
        _x.sourcePropertyName = sourcePropertyName;
        return _x;
    }

    @Property(name="targetPropertyName")
    @JsonIgnore
    public Optional<String> getTargetPropertyName() {
        return Optional.ofNullable(targetPropertyName);
    }

    public EducationIdentityMatchingOptions withTargetPropertyName(String targetPropertyName) {
        EducationIdentityMatchingOptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationIdentityMatchingOptions");
        _x.targetPropertyName = targetPropertyName;
        return _x;
    }

    @Property(name="targetDomain")
    @JsonIgnore
    public Optional<String> getTargetDomain() {
        return Optional.ofNullable(targetDomain);
    }

    public EducationIdentityMatchingOptions withTargetDomain(String targetDomain) {
        EducationIdentityMatchingOptions _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationIdentityMatchingOptions");
        _x.targetDomain = targetDomain;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private EducationUserRole appliesTo;
        private String sourcePropertyName;
        private String targetPropertyName;
        private String targetDomain;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder appliesTo(EducationUserRole appliesTo) {
            this.appliesTo = appliesTo;
            this.changedFields = changedFields.add("appliesTo");
            return this;
        }

        public Builder sourcePropertyName(String sourcePropertyName) {
            this.sourcePropertyName = sourcePropertyName;
            this.changedFields = changedFields.add("sourcePropertyName");
            return this;
        }

        public Builder targetPropertyName(String targetPropertyName) {
            this.targetPropertyName = targetPropertyName;
            this.changedFields = changedFields.add("targetPropertyName");
            return this;
        }

        public Builder targetDomain(String targetDomain) {
            this.targetDomain = targetDomain;
            this.changedFields = changedFields.add("targetDomain");
            return this;
        }

        public EducationIdentityMatchingOptions build() {
            EducationIdentityMatchingOptions _x = new EducationIdentityMatchingOptions();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.educationIdentityMatchingOptions";
            _x.appliesTo = appliesTo;
            _x.sourcePropertyName = sourcePropertyName;
            _x.targetPropertyName = targetPropertyName;
            _x.targetDomain = targetDomain;
            return _x;
        }
    }

    private EducationIdentityMatchingOptions _copy() {
        EducationIdentityMatchingOptions _x = new EducationIdentityMatchingOptions();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.appliesTo = appliesTo;
        _x.sourcePropertyName = sourcePropertyName;
        _x.targetPropertyName = targetPropertyName;
        _x.targetDomain = targetDomain;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EducationIdentityMatchingOptions[");
        b.append("appliesTo=");
        b.append(this.appliesTo);
        b.append(", ");
        b.append("sourcePropertyName=");
        b.append(this.sourcePropertyName);
        b.append(", ");
        b.append("targetPropertyName=");
        b.append(this.targetPropertyName);
        b.append(", ");
        b.append("targetDomain=");
        b.append(this.targetDomain);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
