package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "matchingOptions"})
@JsonInclude(Include.NON_NULL)
public class EducationIdentityMatchingConfiguration extends EducationIdentitySynchronizationConfiguration implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("matchingOptions")
    protected List<EducationIdentityMatchingOptions> matchingOptions;

    @JsonProperty("matchingOptions@nextLink")
    protected String matchingOptionsNextLink;

    protected EducationIdentityMatchingConfiguration() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.educationIdentityMatchingConfiguration";
    }

    @Property(name="matchingOptions")
    @JsonIgnore
    public CollectionPage<EducationIdentityMatchingOptions> getMatchingOptions() {
        return new CollectionPage<EducationIdentityMatchingOptions>(contextPath, EducationIdentityMatchingOptions.class, matchingOptions, Optional.ofNullable(matchingOptionsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="matchingOptions")
    @JsonIgnore
    public CollectionPage<EducationIdentityMatchingOptions> getMatchingOptions(HttpRequestOptions options) {
        return new CollectionPage<EducationIdentityMatchingOptions>(contextPath, EducationIdentityMatchingOptions.class, matchingOptions, Optional.ofNullable(matchingOptionsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEducationIdentityMatchingConfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private List<EducationIdentityMatchingOptions> matchingOptions;
        private String matchingOptionsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder matchingOptions(List<EducationIdentityMatchingOptions> matchingOptions) {
            this.matchingOptions = matchingOptions;
            this.changedFields = changedFields.add("matchingOptions");
            return this;
        }

        public Builder matchingOptions(EducationIdentityMatchingOptions... matchingOptions) {
            return matchingOptions(Arrays.asList(matchingOptions));
        }

        public Builder matchingOptionsNextLink(String matchingOptionsNextLink) {
            this.matchingOptionsNextLink = matchingOptionsNextLink;
            this.changedFields = changedFields.add("matchingOptions");
            return this;
        }

        public EducationIdentityMatchingConfiguration build() {
            EducationIdentityMatchingConfiguration _x = new EducationIdentityMatchingConfiguration();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.educationIdentityMatchingConfiguration";
            _x.matchingOptions = matchingOptions;
            _x.matchingOptionsNextLink = matchingOptionsNextLink;
            return _x;
        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EducationIdentityMatchingConfiguration[");
        b.append("matchingOptions=");
        b.append(this.matchingOptions);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
