package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.EducationUserRole;

@JsonPropertyOrder({
    "@odata.type", 
    "appliesTo", 
    "name"})
@JsonInclude(Include.NON_NULL)
public class EducationIdentityDomain implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("appliesTo")
    protected EducationUserRole appliesTo;

    @JsonProperty("name")
    protected String name;

    protected EducationIdentityDomain() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.educationIdentityDomain";
    }

    @Property(name="appliesTo")
    @JsonIgnore
    public Optional<EducationUserRole> getAppliesTo() {
        return Optional.ofNullable(appliesTo);
    }

    public EducationIdentityDomain withAppliesTo(EducationUserRole appliesTo) {
        EducationIdentityDomain _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationIdentityDomain");
        _x.appliesTo = appliesTo;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public EducationIdentityDomain withName(String name) {
        EducationIdentityDomain _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationIdentityDomain");
        _x.name = name;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private EducationUserRole appliesTo;
        private String name;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder appliesTo(EducationUserRole appliesTo) {
            this.appliesTo = appliesTo;
            this.changedFields = changedFields.add("appliesTo");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public EducationIdentityDomain build() {
            EducationIdentityDomain _x = new EducationIdentityDomain();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.educationIdentityDomain";
            _x.appliesTo = appliesTo;
            _x.name = name;
            return _x;
        }
    }

    private EducationIdentityDomain _copy() {
        EducationIdentityDomain _x = new EducationIdentityDomain();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.appliesTo = appliesTo;
        _x.name = name;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EducationIdentityDomain[");
        b.append("appliesTo=");
        b.append(this.appliesTo);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
