package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "originalFormId", 
    "formId", 
    "isGroupForm", 
    "viewUrl", 
    "editUrl"})
@JsonInclude(Include.NON_NULL)
public class EducationFormResource extends EducationResource implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("originalFormId")
    protected String originalFormId;

    @JsonProperty("formId")
    protected String formId;

    @JsonProperty("isGroupForm")
    protected Boolean isGroupForm;

    @JsonProperty("viewUrl")
    protected String viewUrl;

    @JsonProperty("editUrl")
    protected String editUrl;

    protected EducationFormResource() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.educationFormResource";
    }

    @Property(name="originalFormId")
    @JsonIgnore
    public Optional<String> getOriginalFormId() {
        return Optional.ofNullable(originalFormId);
    }

    public EducationFormResource withOriginalFormId(String originalFormId) {
        EducationFormResource _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationFormResource");
        _x.originalFormId = originalFormId;
        return _x;
    }

    @Property(name="formId")
    @JsonIgnore
    public Optional<String> getFormId() {
        return Optional.ofNullable(formId);
    }

    public EducationFormResource withFormId(String formId) {
        EducationFormResource _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationFormResource");
        _x.formId = formId;
        return _x;
    }

    @Property(name="isGroupForm")
    @JsonIgnore
    public Optional<Boolean> getIsGroupForm() {
        return Optional.ofNullable(isGroupForm);
    }

    public EducationFormResource withIsGroupForm(Boolean isGroupForm) {
        EducationFormResource _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationFormResource");
        _x.isGroupForm = isGroupForm;
        return _x;
    }

    @Property(name="viewUrl")
    @JsonIgnore
    public Optional<String> getViewUrl() {
        return Optional.ofNullable(viewUrl);
    }

    public EducationFormResource withViewUrl(String viewUrl) {
        EducationFormResource _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationFormResource");
        _x.viewUrl = viewUrl;
        return _x;
    }

    @Property(name="editUrl")
    @JsonIgnore
    public Optional<String> getEditUrl() {
        return Optional.ofNullable(editUrl);
    }

    public EducationFormResource withEditUrl(String editUrl) {
        EducationFormResource _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.educationFormResource");
        _x.editUrl = editUrl;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderEducationFormResource() {
        return new Builder();
    }

    public static final class Builder {
        private String displayName;
        private OffsetDateTime createdDateTime;
        private IdentitySet createdBy;
        private OffsetDateTime lastModifiedDateTime;
        private IdentitySet lastModifiedBy;
        private String originalFormId;
        private String formId;
        private Boolean isGroupForm;
        private String viewUrl;
        private String editUrl;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder createdBy(IdentitySet createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder lastModifiedBy(IdentitySet lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            this.changedFields = changedFields.add("lastModifiedBy");
            return this;
        }

        public Builder originalFormId(String originalFormId) {
            this.originalFormId = originalFormId;
            this.changedFields = changedFields.add("originalFormId");
            return this;
        }

        public Builder formId(String formId) {
            this.formId = formId;
            this.changedFields = changedFields.add("formId");
            return this;
        }

        public Builder isGroupForm(Boolean isGroupForm) {
            this.isGroupForm = isGroupForm;
            this.changedFields = changedFields.add("isGroupForm");
            return this;
        }

        public Builder viewUrl(String viewUrl) {
            this.viewUrl = viewUrl;
            this.changedFields = changedFields.add("viewUrl");
            return this;
        }

        public Builder editUrl(String editUrl) {
            this.editUrl = editUrl;
            this.changedFields = changedFields.add("editUrl");
            return this;
        }

        public EducationFormResource build() {
            EducationFormResource _x = new EducationFormResource();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.educationFormResource";
            _x.displayName = displayName;
            _x.createdDateTime = createdDateTime;
            _x.createdBy = createdBy;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.lastModifiedBy = lastModifiedBy;
            _x.originalFormId = originalFormId;
            _x.formId = formId;
            _x.isGroupForm = isGroupForm;
            _x.viewUrl = viewUrl;
            _x.editUrl = editUrl;
            return _x;
        }
    }

    private EducationFormResource _copy() {
        EducationFormResource _x = new EducationFormResource();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.displayName = displayName;
        _x.createdDateTime = createdDateTime;
        _x.createdBy = createdBy;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.lastModifiedBy = lastModifiedBy;
        _x.originalFormId = originalFormId;
        _x.formId = formId;
        _x.isGroupForm = isGroupForm;
        _x.viewUrl = viewUrl;
        _x.editUrl = editUrl;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EducationFormResource[");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("lastModifiedBy=");
        b.append(this.lastModifiedBy);
        b.append(", ");
        b.append("originalFormId=");
        b.append(this.originalFormId);
        b.append(", ");
        b.append("formId=");
        b.append(this.formId);
        b.append(", ");
        b.append("isGroupForm=");
        b.append(this.isGroupForm);
        b.append(", ");
        b.append("viewUrl=");
        b.append(this.viewUrl);
        b.append(", ");
        b.append("editUrl=");
        b.append(this.editUrl);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
